/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetRequest
extends SingleShardOperationRequest {
    private String[] fields;
    private boolean refresh = false;

    GetRequest() {
    }

    public GetRequest(String index) {
        super(index, null, null);
    }

    public GetRequest(String index, String type, String id) {
        super(index, type, id);
    }

    @Required
    public GetRequest index(String index) {
        this.index = index;
        return this;
    }

    @Required
    public GetRequest type(String type) {
        this.type = type;
        return this;
    }

    @Required
    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    @Override
    public GetRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public GetRequest operationThreaded(boolean threadedOperation) {
        super.operationThreaded(threadedOperation);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.refresh = in.readBoolean();
        int size = in.readInt();
        if (size >= 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.refresh);
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.length);
            for (String field : this.fields) {
                out.writeUTF(field);
            }
        }
    }

    public String toString() {
        return "[" + this.index + "][" + this.type + "][" + this.id + "]";
    }
}

