/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.Immutable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

@Immutable
public class IndexMetaData {
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    private final String index;
    private final State state;
    private final ImmutableSet<String> aliases;
    private final Settings settings;
    private final ImmutableMap<String, MappingMetaData> mappings;
    private final transient int totalNumberOfShards;

    private IndexMetaData(String index, State state, Settings settings, ImmutableMap<String, MappingMetaData> mappings) {
        Preconditions.checkArgument(settings.getAsInt(SETTING_NUMBER_OF_SHARDS, -1) != -1, "must specify numberOfShards for index [" + index + "]");
        Preconditions.checkArgument(settings.getAsInt(SETTING_NUMBER_OF_REPLICAS, -1) != -1, "must specify numberOfReplicas for index [" + index + "]");
        this.index = index;
        this.state = state;
        this.settings = settings;
        this.mappings = mappings;
        this.totalNumberOfShards = this.numberOfShards() * (this.numberOfReplicas() + 1);
        this.aliases = ImmutableSet.copyOf(settings.getAsArray("index.aliases"));
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public State state() {
        return this.state;
    }

    public State getState() {
        return this.state();
    }

    public int numberOfShards() {
        return this.settings.getAsInt(SETTING_NUMBER_OF_SHARDS, -1);
    }

    public int getNumberOfShards() {
        return this.numberOfShards();
    }

    public int numberOfReplicas() {
        return this.settings.getAsInt(SETTING_NUMBER_OF_REPLICAS, -1);
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas();
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableSet<String> aliases() {
        return this.aliases;
    }

    public ImmutableSet<String> getAliases() {
        return this.aliases();
    }

    public ImmutableMap<String, MappingMetaData> mappings() {
        return this.mappings;
    }

    public ImmutableMap<String, MappingMetaData> getMappings() {
        return this.mappings();
    }

    public MappingMetaData mapping(String mappingType) {
        return this.mappings.get(mappingType);
    }

    public static Builder newIndexMetaDataBuilder(String index) {
        return new Builder(index);
    }

    public static Builder newIndexMetaDataBuilder(IndexMetaData indexMetaData) {
        return new Builder(indexMetaData);
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private MapBuilder<String, MappingMetaData> mappings = MapBuilder.newMapBuilder();

        public Builder(String index) {
            this.index = index;
        }

        public Builder(IndexMetaData indexMetaData) {
            this(indexMetaData.index());
            this.settings(indexMetaData.settings());
            this.mappings.putAll(indexMetaData.mappings);
            this.state = indexMetaData.state;
        }

        public String index() {
            return this.index;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = ImmutableSettings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = ImmutableSettings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public int numberOfReplicas() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, -1);
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(MappingMetaData mappingMd) {
            this.mappings.put(mappingMd.type(), mappingMd);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            return this.putMapping(new MappingMetaData(mappingType, new CompressedString(mappingSource)));
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public IndexMetaData build() {
            return new IndexMetaData(this.index, this.state, this.settings, this.mappings.immutableMap());
        }

        public static void toXContent(IndexMetaData indexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("state", indexMetaData.state().toString().toLowerCase());
            builder.startObject("settings");
            for (Map.Entry entry : indexMetaData.settings().getAsMap().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
            builder.startArray("mappings");
            for (Map.Entry entry : indexMetaData.mappings().entrySet()) {
                byte[] data = ((MappingMetaData)entry.getValue()).source().uncompressed();
                XContentParser parser = XContentFactory.xContent(data).createParser(data);
                Map<String, Object> mapping = parser.map();
                parser.close();
                builder.map(mapping);
            }
            builder.endArray();
            builder.endObject();
        }

        public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            String key = parser.currentName();
                            token = parser.nextToken();
                            String value = parser.text();
                            settingsBuilder.put(key, value);
                        }
                        builder.settings(settingsBuilder.build());
                        continue;
                    }
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Map<String, Object> mapping = parser.map();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        String mappingSource = XContentFactory.jsonBuilder().map(mapping).string();
                        if (mappingSource == null) continue;
                        builder.putMapping(new MappingMetaData(mappingType, new CompressedString(mappingSource)));
                    }
                    continue;
                }
                if (!token.isValue() || !"state".equals(currentFieldName)) continue;
                builder.state(State.fromString(parser.text()));
            }
            return builder.build();
        }

        public static IndexMetaData readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder(in.readUTF());
            builder.state(State.fromId(in.readByte()));
            builder.settings(ImmutableSettings.readSettingsFromStream(in));
            int mappingsSize = in.readVInt();
            for (int i = 0; i < mappingsSize; ++i) {
                MappingMetaData mappingMd = MappingMetaData.readFrom(in);
                builder.putMapping(mappingMd);
            }
            return builder.build();
        }

        public static void writeTo(IndexMetaData indexMetaData, StreamOutput out) throws IOException {
            out.writeUTF(indexMetaData.index());
            out.writeByte(indexMetaData.state().id());
            ImmutableSettings.writeSettingsToStream(indexMetaData.settings(), out);
            out.writeVInt(indexMetaData.mappings().size());
            for (MappingMetaData mappingMd : indexMetaData.mappings().values()) {
                MappingMetaData.writeTo(mappingMd, out);
            }
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new ElasticSearchIllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new ElasticSearchIllegalStateException("No state match for [" + state + "]");
        }
    }
}

