/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.StreamInput;

public class LZFStreamInput
extends StreamInput {
    public static final int EOF_FLAG = -1;
    private final byte[] compressedBytes = new byte[65535];
    private final byte[] uncompressedBytes = new byte[65535];
    private int bufferPosition = 0;
    private int bufferLength = 0;
    private StreamInput in;

    public LZFStreamInput() {
    }

    public LZFStreamInput(StreamInput in) throws IOException {
        this.in = in;
        this.readyBuffer();
    }

    @Override
    public int read() throws IOException {
        int returnValue = -1;
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            returnValue = this.uncompressedBytes[this.bufferPosition++] & 0xFF;
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int outputPos = off;
        this.readyBuffer();
        if (this.bufferLength == -1) {
            return -1;
        }
        while (outputPos < len && this.bufferPosition < this.bufferLength) {
            int chunkLength = Math.min(this.bufferLength - this.bufferPosition, len - outputPos);
            System.arraycopy(this.uncompressedBytes, this.bufferPosition, b, outputPos, chunkLength);
            outputPos += chunkLength;
            this.bufferPosition += chunkLength;
            this.readyBuffer();
        }
        return outputPos - off;
    }

    @Override
    public byte readByte() throws IOException {
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            return this.uncompressedBytes[this.bufferPosition++];
        }
        throw new EOFException();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int result = this.read(b, offset, len);
        if (result < len) {
            throw new EOFException();
        }
    }

    @Override
    public void reset() throws IOException {
        this.bufferPosition = 0;
        this.bufferLength = 0;
        this.in.reset();
    }

    public void reset(StreamInput in) throws IOException {
        this.in = in;
        this.bufferPosition = 0;
        this.bufferLength = 0;
        this.readyBuffer();
    }

    public void resetToBufferStart() {
        this.bufferPosition = 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void readyBuffer() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferLength = LZFDecoder.decompressChunk(this.in, this.compressedBytes, this.uncompressedBytes);
            this.bufferPosition = 0;
        }
    }
}

