/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.io.stream.StreamOutput;

public class LZFStreamOutput
extends StreamOutput {
    private StreamOutput out;
    private final byte[] outputBuffer = new byte[65535];
    private final ChunkEncoder encoder = new ChunkEncoder(65535);
    private int position = 0;

    public LZFStreamOutput(StreamOutput out) {
        this.out = out;
    }

    @Override
    public void write(int singleByte) throws IOException {
        if (this.position >= this.outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this.outputBuffer[this.position++] = (byte)(singleByte & 0xFF);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.position >= this.outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this.outputBuffer[this.position++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        int inputCursor = offset;
        int remainingBytes = length;
        while (remainingBytes > 0) {
            if (this.position >= this.outputBuffer.length) {
                this.writeCompressedBlock();
            }
            int chunkLength = remainingBytes > this.outputBuffer.length - this.position ? this.outputBuffer.length - this.position : remainingBytes;
            System.arraycopy(b, inputCursor, this.outputBuffer, this.position, chunkLength);
            this.position += chunkLength;
            remainingBytes -= chunkLength;
            inputCursor += chunkLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            this.writeCompressedBlock();
        }
        finally {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public void reset() throws IOException {
        this.position = 0;
        this.out.reset();
    }

    public void reset(StreamOutput out) throws IOException {
        this.out = out;
        this.reset();
    }

    public StreamOutput wrappedOut() {
        return this.out;
    }

    private void writeCompressedBlock() throws IOException {
        if (this.position > 0) {
            this.encoder.encodeChunk(this.out, this.outputBuffer, 0, this.position);
            this.position = 0;
        }
    }
}

