/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocSet;

public class AllDocSet
extends DocSet {
    private final int maxDoc;

    public AllDocSet(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean get(int doc) throws IOException {
        return doc < this.maxDoc;
    }

    @Override
    public long sizeInBytes() {
        return 4L;
    }

    public DocIdSetIterator iterator() throws IOException {
        return new AllDocIdSetIterator(this.maxDoc);
    }

    private final class AllDocIdSetIterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private int doc = -1;

        private AllDocIdSetIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            if (++this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            this.doc = target;
            if (this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
    }
}

