/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.similar.MoreLikeThis;
import org.elasticsearch.common.io.FastStringReader;

public class MoreLikeThisQuery
extends Query {
    public static final float DEFAULT_PERCENT_TERMS_TO_MATCH = 0.3f;
    private Similarity similarity;
    private String likeText;
    private String[] moreLikeFields;
    private Analyzer analyzer;
    private float percentTermsToMatch = 0.3f;
    private int minTermFrequency = 2;
    private int maxQueryTerms = 25;
    private Set<?> stopWords = MoreLikeThis.DEFAULT_STOP_WORDS;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private boolean boostTerms = false;
    private float boostTermsFactor = 1.0f;

    public MoreLikeThisQuery() {
    }

    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer) {
        this.likeText = likeText;
        this.moreLikeFields = moreLikeFields;
        this.analyzer = analyzer;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        MoreLikeThis mlt = new MoreLikeThis(reader, (Similarity)(this.similarity == null ? new DefaultSimilarity() : this.similarity));
        mlt.setFieldNames(this.moreLikeFields);
        mlt.setAnalyzer(this.analyzer);
        mlt.setMinTermFreq(this.minTermFrequency);
        mlt.setMinDocFreq(this.minDocFreq);
        mlt.setMaxDocFreq(this.maxDocFreq);
        mlt.setMaxQueryTerms(this.maxQueryTerms);
        mlt.setMinWordLen(this.minWordLen);
        mlt.setMaxWordLen(this.maxWordLen);
        mlt.setStopWords(this.stopWords);
        mlt.setBoost(this.boostTerms);
        mlt.setBoostFactor(this.boostTermsFactor);
        BooleanQuery bq = (BooleanQuery)mlt.like((Reader)new FastStringReader(this.likeText));
        BooleanClause[] clauses = bq.getClauses();
        bq.setMinimumNumberShouldMatch((int)((float)clauses.length * this.percentTermsToMatch));
        return bq;
    }

    public String toString(String field) {
        return "like:" + this.likeText;
    }

    public String getLikeText() {
        return this.likeText;
    }

    public void setLikeText(String likeText) {
        this.likeText = likeText;
    }

    public String[] getMoreLikeFields() {
        return this.moreLikeFields;
    }

    public void setMoreLikeFields(String[] moreLikeFields) {
        this.moreLikeFields = moreLikeFields;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public float getPercentTermsToMatch() {
        return this.percentTermsToMatch;
    }

    public void setPercentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
    }

    public int getMinTermFrequency() {
        return this.minTermFrequency;
    }

    public void setMinTermFrequency(int minTermFrequency) {
        this.minTermFrequency = minTermFrequency;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public int getMaxWordLen() {
        return this.maxWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public boolean isBoostTerms() {
        return this.boostTerms;
    }

    public void setBoostTerms(boolean boostTerms) {
        this.boostTerms = boostTerms;
    }

    public float getBoostTermsFactor() {
        return this.boostTermsFactor;
    }

    public void setBoostTermsFactor(float boostTermsFactor) {
        this.boostTermsFactor = boostTermsFactor;
    }
}

