/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.local.LocalGatewayMetaState;
import org.elasticsearch.gateway.local.LocalGatewayStartedShards;
import org.elasticsearch.gateway.local.TransportNodesListGatewayMetaState;
import org.elasticsearch.gateway.local.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.gateway.local.LocalIndexGatewayModule;

public class LocalGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway,
ClusterStateListener {
    private File location;
    private final ClusterService clusterService;
    private final NodeEnvironment nodeEnv;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final TransportNodesListGatewayStartedShards listGatewayStartedShards;
    private volatile LocalGatewayMetaState currentMetaState;
    private volatile LocalGatewayStartedShards currentStartedShards;
    private volatile ExecutorService executor;
    private volatile boolean initialized = false;

    @Inject
    public LocalGateway(Settings settings, ClusterService clusterService, NodeEnvironment nodeEnv, TransportNodesListGatewayMetaState listGatewayMetaState, TransportNodesListGatewayStartedShards listGatewayStartedShards) {
        super(settings);
        this.clusterService = clusterService;
        this.nodeEnv = nodeEnv;
        this.listGatewayMetaState = listGatewayMetaState.initGateway(this);
        this.listGatewayStartedShards = listGatewayStartedShards.initGateway(this);
    }

    @Override
    public String type() {
        return "local";
    }

    public LocalGatewayMetaState currentMetaState() {
        this.lazyInitialize();
        return this.currentMetaState;
    }

    public LocalGatewayStartedShards currentStartedShards() {
        this.lazyInitialize();
        return this.currentStartedShards;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.executor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(this.settings, "gateway"));
        this.lazyInitialize();
        this.clusterService.add(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.clusterService.remove(this);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void performStateRecovery(Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        HashSet<String> nodesIds = Sets.newHashSet();
        nodesIds.addAll(this.clusterService.state().nodes().masterNodes().keySet());
        TransportNodesListGatewayMetaState.NodesLocalGatewayMetaState nodesState = this.listGatewayMetaState.list(nodesIds, null).actionGet();
        if (nodesState.failures().length > 0) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                this.logger.warn("failed to fetch state from node", failedNodeException, new Object[0]);
            }
        }
        TransportNodesListGatewayMetaState.NodeLocalGatewayMetaState electedState = null;
        for (TransportNodesListGatewayMetaState.NodeLocalGatewayMetaState nodeState : nodesState) {
            if (nodeState.state() == null) continue;
            if (electedState == null) {
                electedState = nodeState;
                continue;
            }
            if (nodeState.state().version() <= electedState.state().version()) continue;
            electedState = nodeState;
        }
        if (electedState == null) {
            this.logger.debug("no state elected", new Object[0]);
            listener.onSuccess(ClusterState.builder().build());
        } else {
            this.logger.debug("elected state from [{}]", electedState.node());
            listener.onSuccess(ClusterState.builder().version(electedState.state().version()).metaData(electedState.state().metaData()).build());
        }
    }

    @Override
    public Class<? extends Module> suggestIndexGateway() {
        return LocalIndexGatewayModule.class;
    }

    @Override
    public void reset() throws Exception {
        FileSystemUtils.deleteRecursively(this.nodeEnv.nodeDataLocation());
    }

    @Override
    public void clusterChanged(final ClusterChangedEvent event) {
        if (this.location == null) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (event.state().nodes().localNode().masterNode() && event.metaDataChanged()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    LocalGatewayMetaState.Builder builder = LocalGatewayMetaState.builder();
                    if (LocalGateway.this.currentMetaState != null) {
                        builder.state(LocalGateway.this.currentMetaState);
                    }
                    builder.version(event.state().version());
                    builder.metaData(event.state().metaData());
                    try {
                        File[] files;
                        LocalGatewayMetaState stateToWrite = builder.build();
                        XContentBuilder xContentBuilder = XContentFactory.contentBuilder(XContentType.JSON);
                        xContentBuilder.prettyPrint();
                        xContentBuilder.startObject();
                        LocalGatewayMetaState.Builder.toXContent(stateToWrite, xContentBuilder, ToXContent.EMPTY_PARAMS);
                        xContentBuilder.endObject();
                        File stateFile = new File(LocalGateway.this.location, "metadata-" + event.state().version());
                        FileOutputStream fos = new FileOutputStream(stateFile);
                        fos.write(xContentBuilder.unsafeBytes(), 0, xContentBuilder.unsafeBytesLength());
                        fos.close();
                        FileSystemUtils.syncFile(stateFile);
                        LocalGateway.this.currentMetaState = stateToWrite;
                        for (File file : files = LocalGateway.this.location.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.startsWith("metadata-") && !name.equals("metadata-" + event.state().version());
                            }
                        })) {
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        LocalGateway.this.logger.warn("failed to write updated state", e, new Object[0]);
                    }
                }
            });
        }
        if (event.state().nodes().localNode().dataNode() && event.routingTableChanged()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    File[] files;
                    LocalGatewayStartedShards.Builder builder = LocalGatewayStartedShards.builder();
                    if (LocalGateway.this.currentStartedShards != null) {
                        builder.state(LocalGateway.this.currentStartedShards);
                    }
                    builder.version(event.state().version());
                    for (IndexRoutingTable indexRoutingTable : event.state().routingTable()) {
                        for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                            if (!indexShardRoutingTable.primaryShard().active()) continue;
                            builder.remove(indexShardRoutingTable.shardId());
                        }
                    }
                    RoutingNode routingNode = event.state().readOnlyRoutingNodes().node(event.state().nodes().localNodeId());
                    if (routingNode != null) {
                        for (MutableShardRouting shardRouting : routingNode) {
                            if (!shardRouting.active()) continue;
                            builder.put(shardRouting.shardId(), event.state().version());
                        }
                    }
                    try {
                        LocalGatewayStartedShards stateToWrite = builder.build();
                        XContentBuilder xContentBuilder = XContentFactory.contentBuilder(XContentType.JSON);
                        xContentBuilder.prettyPrint();
                        xContentBuilder.startObject();
                        LocalGatewayStartedShards.Builder.toXContent(stateToWrite, xContentBuilder, ToXContent.EMPTY_PARAMS);
                        xContentBuilder.endObject();
                        File stateFile = new File(LocalGateway.this.location, "shards-" + event.state().version());
                        FileOutputStream fos = new FileOutputStream(stateFile);
                        fos.write(xContentBuilder.unsafeBytes(), 0, xContentBuilder.unsafeBytesLength());
                        fos.close();
                        FileSystemUtils.syncFile(stateFile);
                        LocalGateway.this.currentStartedShards = stateToWrite;
                    }
                    catch (IOException e) {
                        LocalGateway.this.logger.warn("failed to write updated state", e, new Object[0]);
                        return;
                    }
                    for (File file : files = LocalGateway.this.location.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith("shards-") && !name.equals("shards-" + event.state().version());
                        }
                    })) {
                        file.delete();
                    }
                }
            });
        }
    }

    private synchronized void lazyInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (!this.clusterService.localNode().masterNode() && !this.clusterService.localNode().dataNode()) {
            this.location = null;
        } else {
            long version;
            this.location = new File(this.nodeEnv.nodeDataLocation(), "_state");
            this.location.mkdirs();
            if (this.clusterService.localNode().masterNode()) {
                try {
                    version = this.findLatestMetaStateVersion();
                    if (version != -1L) {
                        this.currentMetaState = this.readMetaState(Streams.copyToByteArray(new FileInputStream(new File(this.location, "metadata-" + version))));
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed to read local state (metadata)", e, new Object[0]);
                }
            }
            if (this.clusterService.localNode().dataNode()) {
                try {
                    version = this.findLatestStartedShardsVersion();
                    if (version != -1L) {
                        this.currentStartedShards = this.readStartedShards(Streams.copyToByteArray(new FileInputStream(new File(this.location, "shards-" + version))));
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed to read local state (started shards)", e, new Object[0]);
                }
            }
        }
    }

    private long findLatestStartedShardsVersion() throws IOException {
        long index = -1L;
        for (File stateFile : this.location.listFiles()) {
            long fileIndex;
            String name;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[findLatestState]: Processing [" + stateFile.getName() + "]", new Object[0]);
            }
            if (!(name = stateFile.getName()).startsWith("shards-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
            try {
                this.readStartedShards(Streams.copyToByteArray(new FileInputStream(stateFile)));
                index = fileIndex;
            }
            catch (IOException e) {
                this.logger.warn("[findLatestState]: Failed to read state from [" + name + "], ignoring...", e, new Object[0]);
            }
        }
        return index;
    }

    private long findLatestMetaStateVersion() throws IOException {
        long index = -1L;
        for (File stateFile : this.location.listFiles()) {
            long fileIndex;
            String name;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[findLatestState]: Processing [" + stateFile.getName() + "]", new Object[0]);
            }
            if (!(name = stateFile.getName()).startsWith("metadata-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
            try {
                this.readMetaState(Streams.copyToByteArray(new FileInputStream(stateFile)));
                index = fileIndex;
            }
            catch (IOException e) {
                this.logger.warn("[findLatestState]: Failed to read state from [" + name + "], ignoring...", e, new Object[0]);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalGatewayMetaState readMetaState(byte[] data) throws IOException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(XContentType.JSON).createParser(data);
            LocalGatewayMetaState localGatewayMetaState = LocalGatewayMetaState.Builder.fromXContent(parser);
            return localGatewayMetaState;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalGatewayStartedShards readStartedShards(byte[] data) throws IOException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(XContentType.JSON).createParser(data);
            LocalGatewayStartedShards localGatewayStartedShards = LocalGatewayStartedShards.Builder.fromXContent(parser);
            return localGatewayStartedShards;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

