/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.local.LocalGateway;
import org.elasticsearch.gateway.local.LocalGatewayStartedShards;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesOperationAction<Request, NodesLocalGatewayStartedShards, NodeRequest, NodeLocalGatewayStartedShards> {
    private LocalGateway gateway;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    TransportNodesListGatewayStartedShards initGateway(LocalGateway gateway) {
        this.gateway = gateway;
        return this;
    }

    public ActionFuture<NodesLocalGatewayStartedShards> list(Set<String> nodesIds, @Nullable TimeValue timeout) {
        return this.execute(new Request(nodesIds).timeout(timeout));
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/gateway/local/started-shards";
    }

    @Override
    protected String transportNodeAction() {
        return "/gateway/local/started-shards/node";
    }

    @Override
    protected Request newRequest() {
        return new Request();
    }

    @Override
    protected NodeRequest newNodeRequest() {
        return new NodeRequest();
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId);
    }

    @Override
    protected NodeLocalGatewayStartedShards newNodeResponse() {
        return new NodeLocalGatewayStartedShards();
    }

    @Override
    protected NodesLocalGatewayStartedShards newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeLocalGatewayStartedShards> nodesList = Lists.newArrayList();
        ArrayList<FailedNodeException> failures = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeLocalGatewayStartedShards) {
                nodesList.add((NodeLocalGatewayStartedShards)resp);
                continue;
            }
            if (!(resp instanceof FailedNodeException)) continue;
            failures.add((FailedNodeException)resp);
        }
        return new NodesLocalGatewayStartedShards(this.clusterName, nodesList.toArray(new NodeLocalGatewayStartedShards[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeLocalGatewayStartedShards nodeOperation(NodeRequest request) throws ElasticSearchException {
        return new NodeLocalGatewayStartedShards(this.clusterService.localNode(), this.gateway.currentStartedShards());
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeLocalGatewayStartedShards
    extends NodeOperationResponse {
        private LocalGatewayStartedShards state;

        NodeLocalGatewayStartedShards() {
        }

        public NodeLocalGatewayStartedShards(DiscoveryNode node, LocalGatewayStartedShards state) {
            super(node);
            this.state = state;
        }

        public LocalGatewayStartedShards state() {
            return this.state;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.readBoolean()) {
                this.state = LocalGatewayStartedShards.Builder.readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.state == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                LocalGatewayStartedShards.Builder.writeTo(this.state, out);
            }
        }
    }

    static class NodeRequest
    extends NodeOperationRequest {
        NodeRequest() {
        }

        NodeRequest(String nodeId) {
            super(nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class NodesLocalGatewayStartedShards
    extends NodesOperationResponse<NodeLocalGatewayStartedShards> {
        private FailedNodeException[] failures;

        NodesLocalGatewayStartedShards() {
        }

        public NodesLocalGatewayStartedShards(ClusterName clusterName, NodeLocalGatewayStartedShards[] nodes, FailedNodeException[] failures) {
            super(clusterName, (NodeOperationResponse[])nodes);
            this.failures = failures;
        }

        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeLocalGatewayStartedShards[in.readVInt()];
            for (int i = 0; i < ((NodeLocalGatewayStartedShards[])this.nodes).length; ++i) {
                ((NodeLocalGatewayStartedShards[])this.nodes)[i] = new NodeLocalGatewayStartedShards();
                ((NodeLocalGatewayStartedShards[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeLocalGatewayStartedShards[])this.nodes).length);
            for (NodeLocalGatewayStartedShards response : (NodeLocalGatewayStartedShards[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    static class Request
    extends NodesOperationRequest {
        public Request() {
        }

        public Request(Set<String> nodesIds) {
            super(nodesIds.toArray(new String[nodesIds.size()]));
        }

        @Override
        public Request timeout(TimeValue timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

