/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.doubles;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.trove.list.array.TDoubleArrayList;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleDocFieldData;
import org.elasticsearch.index.field.data.doubles.MultiValueDoubleFieldData;
import org.elasticsearch.index.field.data.doubles.SingleValueDoubleFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class DoubleFieldData
extends NumericFieldData<DoubleDocFieldData> {
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    protected final double[] values;

    protected DoubleFieldData(String fieldName, double[] values) {
        super(fieldName);
        this.values = values;
    }

    @Override
    protected long computeSizeInBytes() {
        return 8 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public abstract double value(int var1);

    public abstract double[] values(int var1);

    @Override
    public DoubleDocFieldData docFieldData(int docId) {
        return (DoubleDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected DoubleDocFieldData createFieldData() {
        return new DoubleDocFieldData(this);
    }

    @Override
    public String stringValue(int docId) {
        return Double.toString(this.value(docId));
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(Double.toString(this.values[i]));
        }
    }

    @Override
    public byte byteValue(int docId) {
        return (byte)this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return (short)this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return (int)this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return (long)this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return (float)this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.DOUBLE;
    }

    public void forEachValue(ValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(this.values[i]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public static DoubleFieldData load(IndexReader reader, String field) throws IOException {
        return FieldDataLoader.load(reader, field, new DoubleTypeLoader());
    }

    static class DoubleTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<DoubleFieldData> {
        private final TDoubleArrayList terms = new TDoubleArrayList();

        DoubleTypeLoader() {
            this.terms.add(0.0);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(FieldCache.NUMERIC_UTILS_DOUBLE_PARSER.parseDouble(term));
        }

        @Override
        public DoubleFieldData buildSingleValue(String field, int[] ordinals) {
            return new SingleValueDoubleFieldData(field, ordinals, this.terms.toArray());
        }

        @Override
        public DoubleFieldData buildMultiValue(String field, int[][] ordinals) {
            return new MultiValueDoubleFieldData(field, ordinals, this.terms.toArray());
        }
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, double var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(double var1);
    }
}

