/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.shorts;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class ShortFieldDataComparator
extends NumericFieldDataComparator {
    private final short[] values;
    private short bottom;

    public ShortFieldDataComparator(int numHits, String fieldName, FieldDataCache fieldDataCache) {
        super(fieldName, fieldDataCache);
        this.values = new short[numHits];
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.SHORT;
    }

    public int compare(int slot1, int slot2) {
        return this.values[slot1] - this.values[slot2];
    }

    public int compareBottom(int doc) {
        return this.bottom - this.currentFieldData.shortValue(doc);
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.currentFieldData.shortValue(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Short.valueOf(this.values[slot]);
    }
}

