/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.ContentPath;

public class DynamicTemplate {
    private final String name;
    private final Map<String, Object> conf;
    private final String pathMatch;
    private final String pathUnmatch;
    private final String match;
    private final String unmatch;
    private final MatchType matchType;
    private final String matchMappingType;
    private final Map<String, Object> mapping;

    public static DynamicTemplate parse(String name, Map<String, Object> conf) throws MapperParsingException {
        String match = null;
        String pathMatch = null;
        String unmatch = null;
        String pathUnmatch = null;
        Map mapping = null;
        String matchMappingType = null;
        String matchPattern = "simple";
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            if ("match".equals(propName)) {
                match = entry.getValue().toString();
                continue;
            }
            if ("path_match".equals(propName)) {
                pathMatch = entry.getValue().toString();
                continue;
            }
            if ("unmatch".equals(propName)) {
                unmatch = entry.getValue().toString();
                continue;
            }
            if ("path_unmatch".equals(propName)) {
                pathUnmatch = entry.getValue().toString();
                continue;
            }
            if ("match_mapping_type".equals(propName)) {
                matchMappingType = entry.getValue().toString();
                continue;
            }
            if ("match_pattern".equals(propName)) {
                matchPattern = entry.getValue().toString();
                continue;
            }
            if (!"mapping".equals(propName)) continue;
            mapping = (Map)entry.getValue();
        }
        if (match == null && pathMatch == null) {
            throw new MapperParsingException("template must have match or path_match set");
        }
        if (mapping == null) {
            throw new MapperParsingException("template must have mapping set");
        }
        return new DynamicTemplate(name, conf, pathMatch, pathUnmatch, match, unmatch, matchMappingType, MatchType.fromString(matchPattern), mapping);
    }

    public DynamicTemplate(String name, Map<String, Object> conf, String pathMatch, String pathUnmatch, String match, String unmatch, String matchMappingType, MatchType matchType, Map<String, Object> mapping) {
        this.name = name;
        this.conf = conf;
        this.pathMatch = pathMatch;
        this.pathUnmatch = pathUnmatch;
        this.match = match;
        this.unmatch = unmatch;
        this.matchType = matchType;
        this.matchMappingType = matchMappingType;
        this.mapping = mapping;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> conf() {
        return this.conf;
    }

    public boolean match(ContentPath path, String name, String dynamicType) {
        if (this.pathMatch != null && !this.patternMatch(this.pathMatch, path.fullPathAsText(name))) {
            return false;
        }
        if (this.match != null && !this.patternMatch(this.match, name)) {
            return false;
        }
        if (this.pathUnmatch != null && this.patternMatch(this.pathUnmatch, path.fullPathAsText(name))) {
            return false;
        }
        if (this.unmatch != null && this.patternMatch(this.unmatch, name)) {
            return false;
        }
        if (this.matchMappingType != null) {
            if (dynamicType == null) {
                return false;
            }
            if (!this.patternMatch(this.matchMappingType, dynamicType)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasType() {
        return this.mapping.containsKey("type");
    }

    public String mappingType(String dynamicType) {
        return this.mapping.containsKey("type") ? this.mapping.get("type").toString() : dynamicType;
    }

    private boolean patternMatch(String pattern, String str) {
        if (this.matchType == MatchType.SIMPLE) {
            return Regex.simpleMatch(pattern, str);
        }
        return str.matches(pattern);
    }

    public Map<String, Object> mappingForName(String name, String dynamicType) {
        return this.processMap(this.mapping, name, dynamicType);
    }

    private Map<String, Object> processMap(Map<String, Object> map, String name, String dynamicType) {
        HashMap<String, Object> processedMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                value = this.processMap(value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)((Object)value), name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedMap.put(key, value);
        }
        return processedMap;
    }

    private List processList(List list, String name, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>();
        for (Object value : list) {
            if (value instanceof Map) {
                value = this.processMap((Map)value, name, dynamicType);
            } else if (value instanceof List) {
                value = this.processList((List)value, name, dynamicType);
            } else if (value instanceof String) {
                value = value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            }
            processedList.add(value);
        }
        return processedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicTemplate that = (DynamicTemplate)o;
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.matchMappingType != null ? !this.matchMappingType.equals(that.matchMappingType) : that.matchMappingType != null) {
            return false;
        }
        if (this.matchType != that.matchType) {
            return false;
        }
        return !(this.unmatch != null ? !this.unmatch.equals(that.unmatch) : that.unmatch != null);
    }

    public int hashCode() {
        int result = this.match != null ? this.match.hashCode() : 0;
        result = 31 * result + (this.unmatch != null ? this.unmatch.hashCode() : 0);
        result = 31 * result + (this.matchType != null ? this.matchType.hashCode() : 0);
        result = 31 * result + (this.matchMappingType != null ? this.matchMappingType.hashCode() : 0);
        return result;
    }

    public static enum MatchType {
        SIMPLE,
        REGEX;


        public static MatchType fromString(String value) {
            if ("simple".equals(value)) {
                return SIMPLE;
            }
            if ("regex".equals(value)) {
                return REGEX;
            }
            throw new ElasticSearchIllegalArgumentException("No matching pattern matched on [" + value + "]");
        }
    }
}

