/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.list.array.TDoubleArrayList;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.FieldDataLoader;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPoint;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointDocFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.mapper.xcontent.geo.MultiValueGeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.SingleValueGeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.GeoHashUtils;

public abstract class GeoPointFieldData
extends FieldData<GeoPointDocFieldData> {
    static ThreadLocal<ThreadLocals.CleanableValue<GeoPoint>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<GeoPoint>>(){

        @Override
        protected ThreadLocals.CleanableValue<GeoPoint> initialValue() {
            return new ThreadLocals.CleanableValue<GeoPoint>(new GeoPoint());
        }
    };
    static ThreadLocal<ThreadLocals.CleanableValue<GeoPointHash>> geoHashCache = new ThreadLocal<ThreadLocals.CleanableValue<GeoPointHash>>(){

        @Override
        protected ThreadLocals.CleanableValue<GeoPointHash> initialValue() {
            return new ThreadLocals.CleanableValue<GeoPointHash>(new GeoPointHash());
        }
    };
    public static final GeoPoint[] EMPTY_ARRAY = new GeoPoint[0];
    protected final double[] lat;
    protected final double[] lon;

    protected GeoPointFieldData(String fieldName, double[] lat, double[] lon) {
        super(fieldName);
        this.lat = lat;
        this.lon = lon;
    }

    public abstract GeoPoint value(int var1);

    public abstract GeoPoint[] values(int var1);

    public abstract double latValue(int var1);

    public abstract double lonValue(int var1);

    public abstract double[] latValues(int var1);

    public abstract double[] lonValues(int var1);

    public double distance(int docId, DistanceUnit unit, double lat, double lon) {
        return GeoDistance.PLANE.calculate(this.latValue(docId), this.lonValue(docId), lat, lon, unit);
    }

    public double distanceGeohash(int docId, DistanceUnit unit, String geoHash) {
        GeoPointHash geoPointHash = geoHashCache.get().get();
        if (geoPointHash.geoHash != geoHash) {
            geoPointHash.geoHash = geoHash;
            double[] decode = GeoHashUtils.decode(geoHash);
            geoPointHash.lat = decode[0];
            geoPointHash.lon = decode[1];
        }
        return GeoDistance.PLANE.calculate(this.latValue(docId), this.lonValue(docId), geoPointHash.lat, geoPointHash.lon, unit);
    }

    @Override
    public GeoPointDocFieldData docFieldData(int docId) {
        return (GeoPointDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected long computeSizeInBytes() {
        return 8 * this.lat.length + RamUsage.NUM_BYTES_ARRAY_HEADER + (8 * this.lon.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
    }

    @Override
    public String stringValue(int docId) {
        return this.value(docId).geohash();
    }

    @Override
    protected GeoPointDocFieldData createFieldData() {
        return new GeoPointDocFieldData(this);
    }

    @Override
    public FieldDataType type() {
        return GeoPointFieldDataType.TYPE;
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc) {
        for (int i = 1; i < this.lat.length; ++i) {
            proc.onValue(GeoHashUtils.encode(this.lat[i], this.lon[i]));
        }
    }

    public void forEachValue(PointValueProc proc) {
        for (int i = 1; i < this.lat.length; ++i) {
            GeoPoint point = valuesCache.get().get();
            point.latlon(this.lat[i], this.lon[i]);
            proc.onValue(point);
        }
    }

    public void forEachValue(ValueProc proc) {
        for (int i = 1; i < this.lat.length; ++i) {
            proc.onValue(this.lat[i], this.lon[i]);
        }
    }

    public static GeoPointFieldData load(IndexReader reader, String field) throws IOException {
        return FieldDataLoader.load(reader, field, new StringTypeLoader());
    }

    static class StringTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<GeoPointFieldData> {
        private final TDoubleArrayList lat = new TDoubleArrayList();
        private final TDoubleArrayList lon = new TDoubleArrayList();

        StringTypeLoader() {
            this.lat.add(0.0);
            this.lon.add(0.0);
        }

        @Override
        public void collectTerm(String term) {
            int comma = term.indexOf(44);
            this.lat.add(Double.parseDouble(term.substring(0, comma)));
            this.lon.add(Double.parseDouble(term.substring(comma + 1)));
        }

        @Override
        public GeoPointFieldData buildSingleValue(String field, int[] ordinals) {
            return new SingleValueGeoPointFieldData(field, ordinals, this.lat.toArray(), this.lon.toArray());
        }

        @Override
        public GeoPointFieldData buildMultiValue(String field, int[][] ordinals) {
            return new MultiValueGeoPointFieldData(field, ordinals, this.lat.toArray(), this.lon.toArray());
        }
    }

    public static interface ValueProc {
        public void onValue(double var1, double var3);
    }

    public static interface PointValueProc {
        public void onValue(GeoPoint var1);
    }

    static class GeoPointHash {
        public double lat;
        public double lon;
        public String geoHash = "";

        GeoPointHash() {
        }
    }
}

