/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;

public class FuzzyQueryBuilder
extends BaseQueryBuilder {
    private final String name;
    private final String value;
    private float boost = -1.0f;
    private Float minSimilarity;
    private Integer prefixLength;

    public FuzzyQueryBuilder(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public FuzzyQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public FuzzyQueryBuilder minSimilarity(float defaultMinSimilarity) {
        this.minSimilarity = Float.valueOf(defaultMinSimilarity);
        return this;
    }

    public FuzzyQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("fuzzy");
        if (this.boost == -1.0f && this.minSimilarity == null && this.prefixLength == null) {
            builder.field(this.name, this.value);
        } else {
            builder.startObject(this.name);
            builder.field("value", this.value);
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.minSimilarity != null) {
                builder.field("min_similarity", this.minSimilarity);
            }
            if (this.prefixLength != null) {
                builder.field("prefix_length", this.prefixLength);
            }
            builder.endObject();
        }
        builder.endObject();
    }
}

