/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.settings.IndexSettings;

public class NotFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "not";

    @Inject
    public NotFilterParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Filter filter = null;
        boolean cache = false;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"filter".equals(currentFieldName)) continue;
                filter = parseContext.parseInnerFilter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if (!"_name".equals(currentFieldName)) continue;
            filterName = parser.text();
        }
        if (filter == null) {
            throw new QueryParsingException(this.index, "filter is required when using `not` filter");
        }
        NotFilter notFilter = new NotFilter(filter);
        if (cache) {
            notFilter = parseContext.cacheFilter(notFilter);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, notFilter);
        }
        return notFilter;
    }
}

