/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParser;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.query.xcontent.XContentFilterParserFactory;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.query.xcontent.XContentQueryParserFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;

public class XContentIndexQueryParser
extends AbstractIndexComponent
implements IndexQueryParser {
    private ThreadLocal<ThreadLocals.CleanableValue<QueryParseContext>> cache = new ThreadLocal<ThreadLocals.CleanableValue<QueryParseContext>>(){

        @Override
        protected ThreadLocals.CleanableValue<QueryParseContext> initialValue() {
            return new ThreadLocals.CleanableValue<QueryParseContext>(new QueryParseContext(XContentIndexQueryParser.this.index, XContentIndexQueryParser.this));
        }
    };
    private final String name;
    final ScriptService scriptService;
    final MapperService mapperService;
    final SimilarityService similarityService;
    final IndexCache indexCache;
    final IndexEngine indexEngine;
    private final Map<String, XContentQueryParser> queryParsers;
    private final Map<String, XContentFilterParser> filterParsers;

    @Inject
    public XContentIndexQueryParser(Index index, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexCache indexCache, IndexEngine indexEngine, @Nullable SimilarityService similarityService, @Nullable Map<String, XContentQueryParserFactory> namedQueryParsers, @Nullable Map<String, XContentFilterParserFactory> namedFilterParsers, @Assisted String name, @Assisted @Nullable Settings settings) {
        super(index, indexSettings);
        this.name = name;
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.similarityService = similarityService;
        this.indexCache = indexCache;
        this.indexEngine = indexEngine;
        ArrayList<XContentQueryParser> queryParsers = Lists.newArrayList();
        if (namedQueryParsers != null) {
            Map<String, Settings> queryParserGroups = indexSettings.getGroups("index.queryparser.query");
            for (Map.Entry entry : namedQueryParsers.entrySet()) {
                String queryParserName = (String)entry.getKey();
                XContentQueryParserFactory xContentQueryParserFactory = (XContentQueryParserFactory)entry.getValue();
                Settings queryParserSettings = queryParserGroups.get(queryParserName);
                if (queryParserSettings == null) {
                    queryParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                queryParsers.add(xContentQueryParserFactory.create(queryParserName, queryParserSettings));
            }
        }
        HashMap<String, XContentQueryParser> queryParsersMap = Maps.newHashMap();
        if (queryParsers != null) {
            for (XContentQueryParser xContentQueryParser : queryParsers) {
                this.add(queryParsersMap, xContentQueryParser);
            }
        }
        this.queryParsers = ImmutableMap.copyOf(queryParsersMap);
        ArrayList<XContentFilterParser> filterParsers = Lists.newArrayList();
        if (namedFilterParsers != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.queryparser.filter");
            for (Map.Entry entry : namedFilterParsers.entrySet()) {
                String filterParserName = (String)entry.getKey();
                XContentFilterParserFactory filterParserFactory = (XContentFilterParserFactory)entry.getValue();
                Settings filterParserSettings = map.get(filterParserName);
                if (filterParserSettings == null) {
                    filterParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                filterParsers.add(filterParserFactory.create(filterParserName, filterParserSettings));
            }
        }
        HashMap<String, XContentFilterParser> hashMap = Maps.newHashMap();
        if (filterParsers != null) {
            for (XContentFilterParser xContentFilterParser : filterParsers) {
                this.add(hashMap, xContentFilterParser);
            }
        }
        this.filterParsers = ImmutableMap.copyOf(hashMap);
    }

    @Override
    public String name() {
        return this.name;
    }

    public XContentQueryParser queryParser(String name) {
        return this.queryParsers.get(name);
    }

    public XContentFilterParser filterParser(String name) {
        return this.filterParsers.get(name);
    }

    @Override
    public ParsedQuery parse(QueryBuilder queryBuilder) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            FastByteArrayOutputStream unsafeBytes = queryBuilder.buildAsUnsafeBytes();
            parser = XContentFactory.xContent(unsafeBytes.unsafeByteArray(), 0, unsafeBytes.size()).createParser(unsafeBytes.unsafeByteArray(), 0, unsafeBytes.size());
            ParsedQuery parsedQuery = this.parse(this.cache.get().get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Override
    public ParsedQuery parse(byte[] source) throws ElasticSearchException {
        return this.parse(source, 0, source.length);
    }

    @Override
    public ParsedQuery parse(byte[] source, int offset, int length) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(source, offset, length).createParser(source, offset, length);
            ParsedQuery parsedQuery = this.parse(this.cache.get().get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Override
    public ParsedQuery parse(String source) throws QueryParsingException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.parse(this.cache.get().get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse [" + source + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Override
    public ParsedQuery parse(XContentParser parser) {
        try {
            return this.parse(this.cache.get().get(), parser);
        }
        catch (IOException e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
    }

    public Filter parseInnerFilter(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get().get();
        context.reset(parser);
        return context.parseInnerFilter();
    }

    public Query parseInnerQuery(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get().get();
        context.reset(parser);
        return context.parseInnerQuery();
    }

    private ParsedQuery parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        parseContext.reset(parser);
        Query query = parseContext.parseInnerQuery();
        return new ParsedQuery(query, parseContext.copyNamedFilters(), parseContext.copyScopePhases());
    }

    private void add(Map<String, XContentFilterParser> map, XContentFilterParser filterParser) {
        for (String name : filterParser.names()) {
            map.put(name.intern(), filterParser);
        }
    }

    private void add(Map<String, XContentQueryParser> map, XContentQueryParser queryParser) {
        for (String name : queryParser.names()) {
            map.put(name.intern(), queryParser);
        }
    }

    public static final class Defaults {
        public static final String QUERY_PREFIX = "index.queryparser.query";
        public static final String FILTER_PREFIX = "index.queryparser.filter";
    }
}

