/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceFacetCollector
extends AbstractFacetCollector {
    protected final String indexFieldName;
    protected final double lat;
    protected final double lon;
    protected final DistanceUnit unit;
    protected final GeoDistance geoDistance;
    protected final FieldDataCache fieldDataCache;
    protected GeoPointFieldData fieldData;
    protected final GeoDistanceFacet.Entry[] entries;

    public GeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context) {
        super(facetName);
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.entries = entries;
        this.geoDistance = geoDistance;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.mapper().fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new FacetPhaseExecutionException(facetName, "field [" + fieldName + "] is not a geo_point field");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.indexFieldName);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (!this.fieldData.hasValue(doc)) {
            return;
        }
        if (this.fieldData.multiValued()) {
            double[] lats = this.fieldData.latValues(doc);
            double[] lons = this.fieldData.lonValues(doc);
            for (int i = 0; i < lats.length; ++i) {
                double distance = this.geoDistance.calculate(this.lat, this.lon, lats[i], lons[i], this.unit);
                for (GeoDistanceFacet.Entry entry : this.entries) {
                    if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                    ++entry.count;
                    entry.total += distance;
                }
            }
        } else {
            double distance = this.geoDistance.calculate(this.lat, this.lon, this.fieldData.latValue(doc), this.fieldData.lonValue(doc), this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                ++entry.count;
                entry.total += distance;
            }
        }
    }

    @Override
    public Facet facet() {
        return new InternalGeoDistanceFacet(this.facetName, this.entries);
    }
}

