/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface RangeFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "range";

    public List<Entry> entries();

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        String fromAsString;
        String toAsString;
        long count;
        double total;

        Entry() {
        }

        public double from() {
            return this.from;
        }

        public double getFrom() {
            return this.from();
        }

        public String fromAsString() {
            if (this.fromAsString != null) {
                return this.fromAsString;
            }
            return Double.toString(this.from);
        }

        public String getFromAsString() {
            return this.fromAsString();
        }

        public double to() {
            return this.to;
        }

        public double getTo() {
            return this.to();
        }

        public String toAsString() {
            if (this.toAsString != null) {
                return this.toAsString;
            }
            return Double.toString(this.to);
        }

        public String getToAsString() {
            return this.toAsString();
        }

        public long count() {
            return this.count;
        }

        public long getCount() {
            return this.count();
        }

        public double total() {
            return this.total;
        }

        public double getTotal() {
            return this.total();
        }

        public double mean() {
            return this.total / (double)this.count;
        }

        public double getMean() {
            return this.mean();
        }
    }
}

