/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.strings.TermsStringFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptTermsStringFieldFacetCollector
extends AbstractFacetCollector {
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final SearchScript script;
    private final Matcher matcher;
    private final ImmutableSet<String> excluded;
    private final TObjectIntHashMap<String> facets;
    private int missing;

    public ScriptTermsStringFieldFacetCollector(String facetName, int size, TermsFacet.ComparatorType comparatorType, SearchContext context, ImmutableSet<String> excluded, Pattern pattern, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
        this.excluded = excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.facets = TermsStringFacetCollector.popFacets();
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.script.setNextDocId(doc);
        Object o = this.script.run();
        if (o == null) {
            ++this.missing;
            return;
        }
        if (o instanceof Iterable) {
            boolean found = false;
            for (Object o1 : (Iterable)o) {
                String value = o1.toString();
                if (!this.match(value)) continue;
                found = true;
                this.facets.adjustOrPutValue(value, 1, 1);
            }
            if (!found) {
                ++this.missing;
            }
        } else if (o instanceof Object[]) {
            boolean found = false;
            for (Object o1 : (Object[])o) {
                String value = o1.toString();
                if (!this.match(value)) continue;
                found = true;
                this.facets.adjustOrPutValue(value, 1, 1);
            }
            if (!found) {
                ++this.missing;
            }
        } else {
            String value = o.toString();
            if (this.match(value)) {
                this.facets.adjustOrPutValue(value, 1, 1);
            } else {
                ++this.missing;
            }
        }
    }

    private boolean match(String value) {
        if (this.excluded != null && this.excluded.contains(value)) {
            return false;
        }
        return this.matcher == null || this.matcher.reset(value).matches();
    }

    @Override
    public Facet facet() {
        if (this.facets.isEmpty()) {
            TermsStringFacetCollector.pushFacets(this.facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalStringTermsFacet.StringEntry>of(), this.missing);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size * this.numberOfShards);
        TObjectIntIterator<String> it = this.facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
        }
        TermsStringFacetCollector.pushFacets(this.facets);
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.missing);
    }
}

