/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedfilters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedFiltersSearchHitPhase
implements SearchHitPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean executionNeeded(SearchContext context) {
        return !context.parsedQuery().namedFilters().isEmpty();
    }

    @Override
    public void execute(SearchContext context, SearchHitPhase.HitContext hitContext) throws ElasticSearchException {
        ArrayList<String> matchedFilters = Lists.newArrayListWithCapacity(2);
        for (Map.Entry entry : context.parsedQuery().namedFilters().entrySet()) {
            String name = (String)entry.getKey();
            Filter filter = (Filter)entry.getValue();
            filter = context.filterCache().cache(filter);
            try {
                DocIdSet docIdSet = filter.getDocIdSet(hitContext.reader());
                if (!(docIdSet instanceof DocSet) || !((DocSet)docIdSet).get(hitContext.docId())) continue;
                matchedFilters.add(name);
            }
            catch (IOException e) {}
        }
        hitContext.hit().matchedFilters(matchedFilters.toArray(new String[matchedFilters.size()]));
    }
}

