/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.DocFieldData;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericDocFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;

public class DocLookup
implements Map {
    private final Map<String, FieldData> localCacheFieldData = Maps.newHashMapWithExpectedSize(4);
    private final MapperService mapperService;
    private final FieldDataCache fieldDataCache;
    private IndexReader reader;
    private Scorer scorer;
    private int docId = -1;

    DocLookup(MapperService mapperService, FieldDataCache fieldDataCache) {
        this.mapperService = mapperService;
        this.fieldDataCache = fieldDataCache;
    }

    public void setNextReader(IndexReader reader) {
        if (this.reader == reader) {
            return;
        }
        this.reader = reader;
        this.docId = -1;
        this.localCacheFieldData.clear();
    }

    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    public <T extends DocFieldData> T field(String key) {
        return (T)((DocFieldData)this.get(key));
    }

    public <T extends NumericDocFieldData> T numeric(String key) {
        return (T)((NumericDocFieldData)this.get(key));
    }

    public float score() throws IOException {
        return this.scorer.score();
    }

    public float getScore() throws IOException {
        return this.scorer.score();
    }

    public Object get(Object key) {
        String fieldName = key.toString();
        FieldData fieldData = this.localCacheFieldData.get(fieldName);
        if (fieldData == null) {
            FieldMapper mapper = this.mapperService.smartNameFieldMapper(fieldName);
            if (mapper == null) {
                throw new ElasticSearchIllegalArgumentException("No field found for [" + fieldName + "]");
            }
            try {
                fieldData = this.fieldDataCache.cache(mapper.fieldDataType(), this.reader, mapper.names().indexName());
            }
            catch (IOException e) {
                throw new ElasticSearchException("Failed to load field data for [" + fieldName + "]", e);
            }
            this.localCacheFieldData.put(fieldName, fieldData);
        }
        return fieldData.docFieldData(this.docId);
    }

    @Override
    public boolean containsKey(Object key) {
        FieldMapper mapper;
        String fieldName = key.toString();
        FieldData fieldData = this.localCacheFieldData.get(fieldName);
        return fieldData != null || (mapper = this.mapperService.smartNameFieldMapper(fieldName)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }
}

