/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder {
    private String lang;
    private final String script;
    private final String type;
    private SortOrder order;
    private Map<String, Object> params;

    public ScriptSortBuilder(String script, String type) {
        this.script = script;
        this.type = type;
    }

    public ScriptSortBuilder param(String name, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value);
        return this;
    }

    @Override
    public ScriptSortBuilder order(SortOrder order) {
        this.order = order;
        return this;
    }

    public ScriptSortBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_script");
        builder.field("script", this.script);
        builder.field("type", this.type);
        if (this.order == SortOrder.DESC) {
            builder.field("reverse", true);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        builder.endObject();
        return builder;
    }
}

