/*
 * Decompiled with CFR 0.152.
 */
package controllers.elasticsearch;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.runtime.Desc;
import play.Invoker;
import play.Logger;
import play.Play;
import play.classloading.enhancers.ControllersEnhancer;
import play.classloading.enhancers.LocalvariablesNamesEnhancer;
import play.classloading.enhancers.PropertiesEnhancer;
import play.data.binding.Binder;
import play.data.validation.MaxSize;
import play.data.validation.Password;
import play.data.validation.Required;
import play.data.validation.Validation;
import play.db.Model;
import play.db.jpa.FileAttachment;
import play.exceptions.TemplateNotFoundException;
import play.i18n.Messages;
import play.mvc.Before;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.utils.Java;

public abstract class CRUD
extends Controller {
    public static String[] $addType0 = new String[0];
    public static String[] $index0 = new String[0];
    public static String[] $list1508310403 = new String[]{"page", "search", "searchFields", "orderBy", "order"};
    public static String[] $show1195259493 = new String[]{"id"};
    public static String[] $attachment95092022 = new String[]{"id", "field"};
    public static String[] $save1195259493 = new String[]{"id"};
    public static String[] $blank0 = new String[0];
    public static String[] $create0 = new String[0];
    public static String[] $delete1195259493 = new String[]{"id"};
    public static String[] $getPageSize0 = new String[0];

    @Before
    public static void addType() throws Exception {
        try {
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
            ObjectType type = ObjectType.get(CRUD.getControllerClass());
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
            Object var1_1 = null;
            Scope.RenderArgs renderArgs = null;
            renderArgs = (Scope.RenderArgs)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$RenderArgs;"), (String)"current");
            renderArgs.put("type", (Object)type);
        }
        finally {
            Object var4_5 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    public static void index() {
        try {
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
            if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                Controller.redirect((String)"controllers.elasticsearch.CRUD.index", (Object[])new Object[0]);
            } else {
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                if (CRUD.getControllerClass() == CRUD.class) {
                    CRUD.forbidden();
                }
                CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/index.html"});
            }
        }
        finally {
            Object var1_2 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void list(int page, String search, String searchFields, String orderBy, String order) {
        try {
            TemplateNotFoundException templateNotFoundException2;
            Long totalCount;
            Long count;
            List<Model> objects;
            ObjectType type;
            block7: {
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"order", (Object)order);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"orderBy", (Object)orderBy);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"searchFields", (Object)searchFields);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"search", (Object)search);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"page", (int)page);
                if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                    Controller.redirect((String)"controllers.elasticsearch.CRUD.list", (Object[])new Object[]{new Integer(page), search, searchFields, orderBy, order});
                    return;
                }
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                if (page < 1) {
                    page = 1;
                }
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"page", (int)page);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"page", (int)page);
                Object var10_6 = null;
                Http.Request request = null;
                Http.Request request2 = request = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                Map map = null;
                map = (Map)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)request2, (String)"args", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.list, ligne 53");
                objects = type.findPage(page, search, searchFields, orderBy, order, (String)map.get("where"));
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"objects", objects);
                var10_6 = null;
                request = null;
                request2 = request = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                map = null;
                map = (Map)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)request2, (String)"args", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.list, ligne 54");
                count = type.count(search, searchFields, (String)map.get("where"));
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"count", (Object)count);
                var10_6 = null;
                request = null;
                request2 = request = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                map = null;
                map = (Map)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)request2, (String)"args", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.list, ligne 55");
                totalCount = type.count(null, null, (String)map.get("where"));
                try {
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"totalCount", (Object)totalCount);
                    CRUD.render((Object[])new Object[]{type, objects, count, totalCount, page, orderBy, order});
                    return;
                }
                catch (TemplateNotFoundException templateNotFoundException2) {
                    if (templateNotFoundException2 instanceof Result) throw templateNotFoundException2;
                    if (!(templateNotFoundException2 instanceof Invoker.Suspend)) break block7;
                    throw templateNotFoundException2;
                }
            }
            TemplateNotFoundException e = templateNotFoundException2;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)((Object)e));
            CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/list.html", type, objects, count, totalCount, page, orderBy, order});
            return;
        }
        finally {
            Object var16_17 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void show(String id) {
        try {
            TemplateNotFoundException templateNotFoundException2;
            Model object;
            ObjectType type;
            block6: {
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"id", (Object)id);
                if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                    Controller.redirect((String)"controllers.elasticsearch.CRUD.show", (Object[])new Object[]{id});
                    return;
                }
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                object = type.findById(id);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                CRUD.notFoundIfNull((Object)object);
                try {
                    CRUD.render((Object[])new Object[]{type, object});
                    return;
                }
                catch (TemplateNotFoundException templateNotFoundException2) {
                    if (templateNotFoundException2 instanceof Result) throw templateNotFoundException2;
                    if (!(templateNotFoundException2 instanceof Invoker.Suspend)) break block6;
                    throw templateNotFoundException2;
                }
            }
            TemplateNotFoundException e = templateNotFoundException2;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)((Object)e));
            CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/show.html", type, object});
            return;
        }
        finally {
            Object var6_7 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    public static void attachment(String id, String field) throws Exception {
        try {
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"field", (Object)field);
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"id", (Object)id);
            if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                Controller.redirect((String)"controllers.elasticsearch.CRUD.attachment", (Object[])new Object[]{id, field});
            } else {
                Model.BinaryField binaryField;
                String string;
                Model.BinaryField attachment;
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                ObjectType type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                Model object = type.findById(id);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                CRUD.notFoundIfNull((Object)object);
                Object att = object.getClass().getField(field).get(object);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"att", (Object)att);
                if (att instanceof Model.BinaryField) {
                    attachment = (Model.BinaryField)att;
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"attachment", (Object)attachment);
                    if (attachment == null || !attachment.exists()) {
                        CRUD.notFound();
                    }
                    Object var6_6 = null;
                    Http.Response response = null;
                    response = (Http.Response)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Response;"), (String)"current");
                    string = attachment.type();
                    binaryField = response;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)binaryField, (String)"contentType", String.class, (Object)string, (String)"play.mvc.Http$Response", (String)"controllers.elasticsearch.CRUD.attachment, ligne 86");
                    CRUD.renderBinary((InputStream)attachment.get(), (long)attachment.length());
                }
                if (att instanceof FileAttachment) {
                    attachment = (FileAttachment)att;
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"attachment", (Object)attachment);
                    if (attachment == null || !attachment.exists()) {
                        CRUD.notFound();
                    }
                    binaryField = attachment;
                    string = null;
                    string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)binaryField, (String)"filename", (String)"play.db.jpa.FileAttachment", (String)"controllers.elasticsearch.CRUD.attachment, ligne 95");
                    CRUD.renderBinary((File)attachment.get(), (String)string);
                }
                CRUD.notFound();
            }
        }
        finally {
            Object var11_12 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(String id) throws Exception {
        try {
            String string;
            ObjectType objectType;
            Scope.Params params;
            Object var4_3;
            Model object;
            ObjectType type;
            block8: {
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"id", (Object)id);
                if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                    Controller.redirect((String)"controllers.elasticsearch.CRUD.save", (Object[])new Object[]{id});
                    return;
                }
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                object = type.findById(id);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                CRUD.notFoundIfNull((Object)object);
                var4_3 = null;
                params = null;
                params = (Scope.Params)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Params;"), (String)"current");
                Binder.bind((Object)object, (String)"object", (Map)params.all());
                var4_3 = null;
                params = null;
                params = (Validation)Java.invokeStatic((Class)Desc.getType((String)"Lplay/data/validation/Validation;"), (String)"current");
                params.valid((Object)object);
                var4_3 = null;
                params = null;
                params = (Validation)Java.invokeStatic((Class)Desc.getType((String)"Lplay/data/validation/Validation;"), (String)"current");
                if (Validation.hasErrors()) {
                    TemplateNotFoundException templateNotFoundException2;
                    block9: {
                        var4_3 = null;
                        params = null;
                        params = (Scope.RenderArgs)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$RenderArgs;"), (String)"current");
                        params.put("error", (Object)Messages.get((Object)"crud.hasErrors", (Object[])new Object[0]));
                        try {
                            Object[] objectArray = new Object[3];
                            var4_3 = null;
                            params = null;
                            params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                            objectType = params;
                            string = null;
                            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.save, ligne 110");
                            objectArray[0] = String.valueOf(string.replace(".", "/")) + "/show.html";
                            objectArray[1] = type;
                            objectArray[2] = object;
                            CRUD.render((Object[])objectArray);
                            break block8;
                        }
                        catch (TemplateNotFoundException templateNotFoundException2) {
                            if (templateNotFoundException2 instanceof Result) throw templateNotFoundException2;
                            if (!(templateNotFoundException2 instanceof Invoker.Suspend)) break block9;
                            throw templateNotFoundException2;
                        }
                    }
                    TemplateNotFoundException e = templateNotFoundException2;
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)((Object)e));
                    CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/show.html", type, object});
                }
            }
            object._save();
            var4_3 = null;
            params = null;
            params = (Scope.Flash)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Flash;"), (String)"current");
            Object[] objectArray = new Object[1];
            objectType = type;
            string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.save, ligne 116");
            objectArray[0] = string;
            params.success(Messages.get((Object)"crud.saved", (Object[])objectArray), new Object[0]);
            var4_3 = null;
            params = null;
            params = (Scope.Params)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Params;"), (String)"current");
            if (params.get("_save") != null) {
                var4_3 = null;
                params = null;
                params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                objectType = params;
                string = null;
                string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.save, ligne 118");
                CRUD.redirect((String)(String.valueOf(string) + ".list"));
            }
            var4_3 = null;
            params = null;
            params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
            objectType = params;
            string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.save, ligne 120");
            CRUD.redirect((String)(String.valueOf(string) + ".show"), (Object[])new Object[]{object._key()});
            return;
        }
        finally {
            Object var10_11 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void blank() throws Exception {
        try {
            TemplateNotFoundException templateNotFoundException2;
            Model object;
            ObjectType type;
            block6: {
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                    Controller.redirect((String)"controllers.elasticsearch.CRUD.blank", (Object[])new Object[0]);
                    return;
                }
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                ObjectType objectType = type;
                Class clazz = null;
                clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.blank, ligne 126");
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"constructor", constructor);
                constructor.setAccessible(true);
                object = (Model)constructor.newInstance(new Object[0]);
                try {
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                    CRUD.render((Object[])new Object[]{type, object});
                    return;
                }
                catch (TemplateNotFoundException templateNotFoundException2) {
                    if (templateNotFoundException2 instanceof Result) throw templateNotFoundException2;
                    if (!(templateNotFoundException2 instanceof Invoker.Suspend)) break block6;
                    throw templateNotFoundException2;
                }
            }
            TemplateNotFoundException e = templateNotFoundException2;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)((Object)e));
            CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/blank.html", type, object});
            return;
        }
        finally {
            Object var8_9 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void create() throws Exception {
        try {
            Scope.Params params;
            Object var4_5;
            Model object;
            Object object2;
            ObjectType objectType;
            ObjectType type;
            block9: {
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                    Controller.redirect((String)"controllers.elasticsearch.CRUD.create", (Object[])new Object[0]);
                    return;
                }
                ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                type = ObjectType.get(CRUD.getControllerClass());
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                CRUD.notFoundIfNull((Object)type);
                objectType = type;
                object2 = null;
                object2 = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.create, ligne 139");
                Constructor constructor = ((Class)object2).getDeclaredConstructor(new Class[0]);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"constructor", constructor);
                constructor.setAccessible(true);
                object = (Model)constructor.newInstance(new Object[0]);
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                var4_5 = null;
                params = null;
                params = (Scope.Params)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Params;"), (String)"current");
                Binder.bind((Object)object, (String)"object", (Map)params.all());
                var4_5 = null;
                params = null;
                params = (Validation)Java.invokeStatic((Class)Desc.getType((String)"Lplay/data/validation/Validation;"), (String)"current");
                params.valid((Object)object);
                var4_5 = null;
                params = null;
                params = (Validation)Java.invokeStatic((Class)Desc.getType((String)"Lplay/data/validation/Validation;"), (String)"current");
                if (Validation.hasErrors()) {
                    TemplateNotFoundException templateNotFoundException2;
                    block10: {
                        var4_5 = null;
                        params = null;
                        params = (Scope.RenderArgs)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$RenderArgs;"), (String)"current");
                        params.put("error", (Object)Messages.get((Object)"crud.hasErrors", (Object[])new Object[0]));
                        try {
                            Object[] objectArray = new Object[3];
                            var4_5 = null;
                            params = null;
                            params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                            objectType = params;
                            object2 = null;
                            object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.create, ligne 147");
                            objectArray[0] = String.valueOf(((String)object2).replace(".", "/")) + "/blank.html";
                            objectArray[1] = type;
                            objectArray[2] = object;
                            CRUD.render((Object[])objectArray);
                            break block9;
                        }
                        catch (TemplateNotFoundException templateNotFoundException2) {
                            if (templateNotFoundException2 instanceof Result) throw templateNotFoundException2;
                            if (!(templateNotFoundException2 instanceof Invoker.Suspend)) break block10;
                            throw templateNotFoundException2;
                        }
                    }
                    TemplateNotFoundException e = templateNotFoundException2;
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)((Object)e));
                    CRUD.render((Object[])new Object[]{"ELASTIC_SEARCH/blank.html", type, object});
                }
            }
            object._save();
            var4_5 = null;
            params = null;
            params = (Scope.Flash)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Flash;"), (String)"current");
            Object[] objectArray = new Object[1];
            objectType = type;
            object2 = null;
            objectArray[0] = object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.create, ligne 153");
            params.success(Messages.get((Object)"crud.created", (Object[])objectArray), new Object[0]);
            var4_5 = null;
            params = null;
            params = (Scope.Params)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Params;"), (String)"current");
            if (params.get("_save") != null) {
                var4_5 = null;
                params = null;
                params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                objectType = params;
                object2 = null;
                object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.create, ligne 155");
                CRUD.redirect((String)(String.valueOf(object2) + ".list"));
            }
            var4_5 = null;
            params = null;
            params = (Scope.Params)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Params;"), (String)"current");
            if (params.get("_saveAndAddAnother") != null) {
                var4_5 = null;
                params = null;
                params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                objectType = params;
                object2 = null;
                object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.create, ligne 158");
                CRUD.redirect((String)(String.valueOf(object2) + ".blank"));
            }
            var4_5 = null;
            params = null;
            params = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
            objectType = params;
            object2 = null;
            object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.create, ligne 160");
            CRUD.redirect((String)(String.valueOf(object2) + ".show"), (Object[])new Object[]{object._key()});
            return;
        }
        finally {
            Object var10_11 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(String id) {
        try {
            String string;
            ObjectType objectType;
            Scope.Flash flash;
            Object var4_4;
            ObjectType type;
            block6: {
                Exception exception2;
                Model object;
                block7: {
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"id", (Object)id);
                    if (!ControllersEnhancer.ControllerInstrumentation.isActionCallAllowed()) {
                        Controller.redirect((String)"controllers.elasticsearch.CRUD.delete", (Object[])new Object[]{id});
                        return;
                    }
                    ControllersEnhancer.ControllerInstrumentation.stopActionCall();
                    type = ObjectType.get(CRUD.getControllerClass());
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"type", (Object)type);
                    CRUD.notFoundIfNull((Object)type);
                    object = type.findById(id);
                    LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"object", (Object)object);
                    CRUD.notFoundIfNull((Object)object);
                    try {
                        object._delete();
                        break block6;
                    }
                    catch (Exception exception2) {
                        if (exception2 instanceof Result) throw exception2;
                        if (!(exception2 instanceof Invoker.Suspend)) break block7;
                        throw exception2;
                    }
                }
                Exception e = exception2;
                LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.addVariable((String)"e", (Object)e);
                var4_4 = null;
                flash = null;
                flash = (Scope.Flash)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Flash;"), (String)"current");
                Object[] objectArray = new Object[1];
                objectType = type;
                string = null;
                string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.delete, ligne 171");
                objectArray[0] = string;
                flash.error(Messages.get((Object)"crud.delete.error", (Object[])objectArray), new Object[0]);
                var4_4 = null;
                flash = null;
                flash = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
                objectType = flash;
                string = null;
                string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.delete, ligne 172");
                CRUD.redirect((String)(String.valueOf(string) + ".show"), (Object[])new Object[]{object._key()});
            }
            var4_4 = null;
            flash = null;
            flash = (Scope.Flash)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Scope$Flash;"), (String)"current");
            Object[] objectArray = new Object[1];
            objectType = type;
            string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD.delete, ligne 174");
            objectArray[0] = string;
            flash.success(Messages.get((Object)"crud.deleted", (Object[])objectArray), new Object[0]);
            var4_4 = null;
            flash = null;
            flash = (Http.Request)Java.invokeStatic((Class)Desc.getType((String)"Lplay/mvc/Http$Request;"), (String)"current");
            objectType = flash;
            string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controller", (String)"play.mvc.Http$Request", (String)"controllers.elasticsearch.CRUD.delete, ligne 175");
            CRUD.redirect((String)(String.valueOf(string) + ".list"));
            return;
        }
        finally {
            Object var10_11 = null;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        }
    }

    static int getPageSize() {
        int n;
        try {
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.enter();
            n = Integer.parseInt(Play.configuration.getProperty("crud.pageSize", "30"));
        }
        catch (Throwable throwable) {
            boolean bl = false;
            LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
            throw throwable;
        }
        int n2 = n;
        LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.exit();
        return n2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface For {
        public Class<? extends Model> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    public static class ObjectType
    implements Comparable<ObjectType> {
        public Class<? extends Controller> controllerClass;
        public Class<? extends Model> entityClass;
        public String name;
        public String modelName;
        public String controllerName;
        public String keyName;

        public ObjectType(Class<? extends Model> modelClass) {
            Object object = modelClass.getSimpleName();
            ObjectType objectType = this;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"modelName", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.CRUD$ObjectType, ligne 208");
            object = modelClass;
            objectType = this;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"entityClass", Class.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.CRUD$ObjectType, ligne 209");
            objectType = this;
            object = null;
            object = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.CRUD$ObjectType, ligne 210");
            object = Model.Manager.factoryFor((Class)object).keyName();
            objectType = this;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"keyName", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.CRUD$ObjectType, ligne 210");
        }

        public ObjectType(String modelClass) throws ClassNotFoundException {
            this(Play.classloader.loadClass(modelClass));
        }

        public static ObjectType forClass(String modelClass) throws ClassNotFoundException {
            return new ObjectType(modelClass);
        }

        public static ObjectType get(Class<? extends Controller> controllerClass) {
            Class<? extends Model> entityClass = ObjectType.getEntityClassForController(controllerClass);
            if (entityClass == null || !Model.class.isAssignableFrom(entityClass)) {
                return null;
            }
            ObjectType type = new ObjectType(entityClass);
            Object object = ObjectType.getName(controllerClass.getSimpleName().replace("$", ""));
            ObjectType objectType = type;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"name", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.get, ligne 228");
            object = controllerClass.getSimpleName().toLowerCase().replace("$", "");
            objectType = type;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"controllerName", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.get, ligne 229");
            object = controllerClass;
            objectType = type;
            PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectType, (String)"controllerClass", Class.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.get, ligne 230");
            return type;
        }

        private static String getName(String name) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (++count == 1) {
                    sb.append(String.valueOf(c).toUpperCase());
                } else {
                    if (Character.isUpperCase(c)) {
                        sb.append(" ");
                    }
                    sb.append(c);
                }
                ++n2;
            }
            return sb.toString();
        }

        public static Class<? extends Model> getEntityClassForController(Class<? extends Controller> controllerClass) {
            if (controllerClass.isAnnotationPresent(For.class)) {
                return controllerClass.getAnnotation(For.class).value();
            }
            Type[] typeArray = controllerClass.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterizedType type;
                Type it = typeArray[n2];
                if (it instanceof ParameterizedType && ((Class)(type = (ParameterizedType)it).getRawType()).getSimpleName().equals("CRUDWrapper")) {
                    return (Class)type.getActualTypeArguments()[0];
                }
                ++n2;
            }
            String name = controllerClass.getSimpleName().replace("$", "");
            name = "models." + name.substring(0, name.length() - 1);
            try {
                return Play.classloader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                try {
                    if (name != null && name.endsWith("ies")) {
                        name = "models." + name.substring(0, name.length() - 3);
                        name = String.valueOf(name) + "y";
                        Logger.info((String)"CRUD Controller: %s", (Object[])new Object[]{name});
                        return Play.classloader.loadClass(name);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        }

        public Object getListAction() {
            ObjectType objectType = this;
            Class clazz = null;
            clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controllerClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.getListAction, ligne 284");
            return Router.reverse((String)(String.valueOf(clazz.getName().replace("$", "")) + ".list"));
        }

        public Object getBlankAction() {
            ObjectType objectType = this;
            Class clazz = null;
            clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"controllerClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.getBlankAction, ligne 288");
            return Router.reverse((String)(String.valueOf(clazz.getName().replace("$", "")) + ".blank"));
        }

        public Long count(String search, String searchFields, String where) {
            ObjectType objectType = this;
            Class clazz = null;
            clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.count, ligne 292");
            return Model.Manager.factoryFor((Class)clazz).count(searchFields == null ? new ArrayList() : Arrays.asList(searchFields.split("[ ]")), search, where);
        }

        public List<Model> findPage(int page, String search, String searchFields, String orderBy, String order, String where) {
            ObjectType objectType = this;
            Class clazz = null;
            clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.findPage, ligne 297");
            return Model.Manager.factoryFor((Class)clazz).fetch((page - 1) * CRUD.getPageSize(), CRUD.getPageSize(), orderBy, order, searchFields == null ? new ArrayList() : Arrays.asList(searchFields.split("[ ]")), search, where);
        }

        public Model findById(Object id) {
            if (id == null) {
                return null;
            }
            ObjectType objectType = this;
            Class clazz = null;
            clazz = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.findById, ligne 302");
            return Model.Manager.factoryFor((Class)clazz).findById(id);
        }

        public List<ObjectField> getFields() {
            ArrayList<ObjectField> fields = new ArrayList<ObjectField>();
            Object object = this;
            Object object2 = null;
            object2 = (Class)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)object, (String)"entityClass", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.getFields, ligne 307");
            for (Model.Property f : Model.Manager.factoryFor((Class)object2).listProperties()) {
                ObjectField of = new ObjectField(f);
                object = of;
                object2 = null;
                object2 = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)object, (String)"type", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType.getFields, ligne 309");
                if (object2 == null) continue;
                fields.add(of);
            }
            return fields;
        }

        public ObjectField getField(String name) {
            Iterator<ObjectField> iterator = this.getFields().iterator();
            while (iterator.hasNext()) {
                ObjectField field;
                ObjectField objectField = field = iterator.next();
                String string = null;
                string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectField, (String)"name", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType.getField, ligne 318");
                if (!string.equals(name)) continue;
                return field;
            }
            return null;
        }

        @Override
        public int compareTo(ObjectType other) {
            ObjectType objectType = this;
            String string = null;
            String string2 = string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.compareTo, ligne 326");
            objectType = other;
            string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.compareTo, ligne 326");
            return string2.compareTo(string);
        }

        public String toString() {
            ObjectType objectType = this;
            String string = null;
            string = (String)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectType, (String)"modelName", (String)"controllers.elasticsearch.CRUD$ObjectType", (String)"controllers.elasticsearch.CRUD$ObjectType.toString, ligne 331");
            return string;
        }

        public Class getControllerClass() {
            return this.controllerClass;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setControllerClass(Class clazz) {
            this.controllerClass = clazz;
        }

        public Class getEntityClass() {
            return this.entityClass;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setEntityClass(Class clazz) {
            this.entityClass = clazz;
        }

        public String getName() {
            return this.name;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setName(String string) {
            this.name = string;
        }

        public String getModelName() {
            return this.modelName;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setModelName(String string) {
            this.modelName = string;
        }

        public String getControllerName() {
            return this.controllerName;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setControllerName(String string) {
            this.controllerName = string;
        }

        public String getKeyName() {
            return this.keyName;
        }

        @PropertiesEnhancer.PlayPropertyAccessor
        public void setKeyName(String string) {
            this.keyName = string;
        }

        public ObjectType() {
        }

        public static class ObjectField {
            private Model.Property property;
            public String type;
            public String name;
            public boolean multiple;
            public boolean required;

            public ObjectField(Model.Property property) {
                Object object = "unknown";
                ObjectField objectField = this;
                PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 337");
                objectField = property;
                object = null;
                Object field = object = (Field)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectField, (String)"field", (String)"play.db.Model$Property", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 343");
                this.property = property;
                if (CharSequence.class.isAssignableFrom(((Field)field).getType())) {
                    int maxSize;
                    object = "text";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 346");
                    if (((AccessibleObject)field).isAnnotationPresent(MaxSize.class) && (maxSize = ((Field)field).getAnnotation(MaxSize.class).value()) > 100) {
                        object = "longtext";
                        objectField = this;
                        PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 350");
                    }
                    if (((AccessibleObject)field).isAnnotationPresent(Password.class)) {
                        object = "password";
                        objectField = this;
                        PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 354");
                    }
                }
                if (Number.class.isAssignableFrom(((Field)field).getType()) || ((Field)field).getType().equals(Double.TYPE) || ((Field)field).getType().equals(Integer.TYPE) || ((Field)field).getType().equals(Long.TYPE)) {
                    object = "number";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 358");
                }
                if (Boolean.class.isAssignableFrom(((Field)field).getType()) || ((Field)field).getType().equals(Boolean.TYPE)) {
                    object = "boolean";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 361");
                }
                if (Date.class.isAssignableFrom(((Field)field).getType())) {
                    object = "date";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)object, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 364");
                }
                objectField = property;
                boolean bl = false;
                bl = (Boolean)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectField, (String)"isRelation", (String)"play.db.Model$Property", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 366");
                if (bl) {
                    String string = "relation";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)string, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 367");
                }
                objectField = property;
                boolean bl2 = false;
                bl2 = (Boolean)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectField, (String)"isMultiple", (String)"play.db.Model$Property", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 369");
                if (bl2) {
                    bl2 = true;
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"multiple", Boolean.TYPE, (boolean)bl2, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 370");
                }
                if (Model.BinaryField.class.isAssignableFrom(((Field)field).getType()) || FileAttachment.class.isAssignableFrom(((Field)field).getType())) {
                    String string = "binary";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)string, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 373");
                }
                if (((Field)field).getType().isEnum()) {
                    String string = "enum";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)string, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 376");
                }
                objectField = property;
                boolean bl3 = false;
                bl3 = (Boolean)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)objectField, (String)"isGenerated", (String)"play.db.Model$Property", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 378");
                if (bl3) {
                    Object var5_9 = null;
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, var5_9, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 379");
                }
                if (((AccessibleObject)field).isAnnotationPresent(Required.class)) {
                    boolean bl4 = true;
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"required", Boolean.TYPE, (boolean)bl4, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 382");
                }
                if (((AccessibleObject)field).isAnnotationPresent(Hidden.class)) {
                    String string = "hidden";
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, (Object)string, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 385");
                }
                if (((AccessibleObject)field).isAnnotationPresent(Exclude.class)) {
                    Object var5_12 = null;
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, var5_12, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 388");
                }
                if (Modifier.isFinal(((Field)field).getModifiers())) {
                    Object var5_13 = null;
                    objectField = this;
                    PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"type", String.class, var5_13, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 391");
                }
                String string = ((Field)field).getName();
                objectField = this;
                PropertiesEnhancer.FieldAccessor.invokeWriteProperty((Object)objectField, (String)"name", String.class, (Object)string, (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.CRUD$ObjectType$ObjectField, ligne 393");
            }

            public List<Object> getChoices() {
                Model.Property property = this.property;
                Model.Choices choices = null;
                choices = (Model.Choices)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)property, (String)"choices", (String)"play.db.Model$Property", (String)"controllers.elasticsearch.CRUD$ObjectType$ObjectField.getChoices, ligne 397");
                return choices.list();
            }

            public String getType() {
                return this.type;
            }

            @PropertiesEnhancer.PlayPropertyAccessor
            public void setType(String string) {
                this.type = string;
            }

            public String getName() {
                return this.name;
            }

            @PropertiesEnhancer.PlayPropertyAccessor
            public void setName(String string) {
                this.name = string;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            @PropertiesEnhancer.PlayPropertyAccessor
            public void setMultiple(boolean bl) {
                this.multiple = bl;
            }

            public boolean getRequired() {
                return this.required;
            }

            @PropertiesEnhancer.PlayPropertyAccessor
            public void setRequired(boolean bl) {
                this.required = bl;
            }

            public ObjectField() {
            }
        }
    }
}

