/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.Model;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.util.ExceptionUtil;
import play.mvc.Router;

public class ElasticSearchPlugin
extends PlayPlugin {
    private ThreadLocal<Client> _session = new ThreadLocal();
    private static boolean started = false;
    private static Map<Class<?>, Boolean> modelIndex = null;

    public Client client() {
        return this._session.get();
    }

    private boolean isLocalMode() {
        Boolean local;
        block5: {
            String client;
            block4: {
                try {
                    client = Play.configuration.getProperty("elasticsearch.client");
                    local = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.local", "true"));
                    if (client != null) break block4;
                    return true;
                }
                catch (Exception e) {
                    Logger.error((String)"Error! Starting in Local Model: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(e)});
                    return true;
                }
            }
            if (!client.equalsIgnoreCase("false") && !client.equalsIgnoreCase("true")) break block5;
            return true;
        }
        return local;
    }

    public static String getHosts() {
        String s = Play.configuration.getProperty("elasticsearch.client");
        if (s == null) {
            return "";
        }
        return s;
    }

    public void onApplicationStart() {
        modelIndex = new HashMap();
        if (this._session.get() != null || started) {
            Logger.debug((String)"Elastic Search Started Already!", (Object[])new Object[0]);
            return;
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("client.transport.sniff", true);
        settings.build();
        Client client = null;
        if (this.isLocalMode()) {
            Logger.info((String)"Starting Elastic Search for Play! in Local Mode", (Object[])new Object[0]);
            NodeBuilder nb = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).local(true).client(false).data(true);
            Node node = nb.node();
            client = node.client();
        } else {
            Logger.info((String)"Connecting Play! to Elastic Search in Client Mode", (Object[])new Object[0]);
            TransportClient c = new TransportClient((Settings.Builder)settings);
            if (Play.configuration.getProperty("elasticsearch.client") == null) {
                throw new RuntimeException("Configuration required - elasticsearch.client when local model is disabled!");
            }
            String[] hosts = ElasticSearchPlugin.getHosts().trim().split(",");
            boolean done = false;
            String[] stringArray = hosts;
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                String[] parts = host.split(":");
                if (parts.length != 2) {
                    throw new RuntimeException("Invalid Host: " + host);
                }
                Logger.info((String)"Transport Client - Host: %s Port: %s", (Object[])new Object[]{parts[0], parts[1]});
                c.addTransportAddress((TransportAddress)new InetSocketTransportAddress(parts[0], Integer.valueOf(parts[1]).intValue()));
                done = true;
                ++n2;
            }
            if (!done) {
                throw new RuntimeException("No Hosts Provided for Elastic Search!");
            }
            client = c;
        }
        Router.addRoute((String)"GET", (String)"/es-admin/", (String)"ElasticSearchAdmin.index");
        Router.addRoute((String)"GET", (String)"/es-admin/lib", (String)"staticDir:elasticsearch_public");
        if (client == null) {
            throw new RuntimeException("Elastic Search Client cannot be null - please check the configuration provided and the health of your Elastic Search instances.");
        }
        this._session.set(client);
    }

    private boolean isElasticSearchable(Object o) {
        Class<?> clazz = o.getClass();
        while (clazz != null) {
            Annotation[] annotationArray = clazz.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a.toString().indexOf("ElasticSearchable") > -1) {
                    return true;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public void onEvent(String message, Object context) {
        if (!StringUtils.startsWith((String)message, (String)"JPASupport.")) {
            return;
        }
        boolean isSearchable = this.isElasticSearchable(context);
        if (!isSearchable) {
            return;
        }
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        Class<?> clazz = context.getClass();
        if (!modelIndex.containsKey(clazz)) {
            Logger.info((String)"Start Index for Class: %s", (Object[])new Object[]{clazz});
            ElasticSearchAdapter.startIndex(plugin.client(), clazz);
        }
        try {
            if (message.equals("JPASupport.objectPersisted") || message.equals("JPASupport.objectUpdated")) {
                ElasticSearchAdapter.indexModel(plugin.client(), (Model)context);
            } else if (message.equals("JPASupport.objectDeleted")) {
                ElasticSearchAdapter.deleteModel(plugin.client(), (Model)context);
            }
            Logger.debug((String)"Elastic Event Done!", (Object[])new Object[0]);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Problem updating entity %s on event %s with error %s", (Object[])new Object[]{context, message, e.getMessage()});
        }
    }
}

