/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardDeleteByQueryRequest
extends ShardReplicationOperationRequest {
    private int shardId;
    private byte[] querySource;
    private String queryParserName;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;

    ShardDeleteByQueryRequest(IndexDeleteByQueryRequest request, int shardId) {
        this.index = request.index();
        this.querySource = request.querySource();
        this.queryParserName = request.queryParserName();
        this.types = request.types();
        this.shardId = shardId;
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.routing = request.routing();
    }

    ShardDeleteByQueryRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            Actions.addValidationError("querySource is missing", validationException);
        }
        return validationException;
    }

    public int shardId() {
        return this.shardId;
    }

    public byte[] querySource() {
        return this.querySource;
    }

    public String queryParserName() {
        return this.queryParserName;
    }

    public String[] types() {
        return this.types;
    }

    public String routing() {
        return this.routing;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.querySource = new byte[in.readVInt()];
        in.readFully(this.querySource);
        if (in.readBoolean()) {
            this.queryParserName = in.readUTF();
        }
        this.shardId = in.readVInt();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.querySource.length);
        out.writeBytes(this.querySource);
        if (this.queryParserName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryParserName);
        }
        out.writeVInt(this.shardId);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = Unicode.fromBytes(this.querySource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "delete_by_query {[" + this.index + "]" + Arrays.toString(this.types) + ", query [" + sSource + "]}";
    }
}

