/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.facet.Facets;
import org.elasticsearch.search.internal.InternalSearchResponse;

public class SearchResponse
implements ActionResponse,
ToXContent {
    private InternalSearchResponse internalResponse;
    private String scrollId;
    private int totalShards;
    private int successfulShards;
    private ShardSearchFailure[] shardFailures;
    private long tookInMillis;

    SearchResponse() {
    }

    public SearchResponse(InternalSearchResponse internalResponse, String scrollId, int totalShards, int successfulShards, long tookInMillis, ShardSearchFailure[] shardFailures) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
    }

    public SearchHits hits() {
        return this.internalResponse.hits();
    }

    public SearchHits getHits() {
        return this.hits();
    }

    public Facets facets() {
        return this.internalResponse.facets();
    }

    public Facets getFacets() {
        return this.facets();
    }

    public boolean timedOut() {
        return this.internalResponse.timedOut();
    }

    public boolean isTimedOut() {
        return this.timedOut();
    }

    public TimeValue took() {
        return new TimeValue(this.tookInMillis);
    }

    public TimeValue getTook() {
        return this.took();
    }

    public long tookInMillis() {
        return this.tookInMillis;
    }

    public long getTookInMillis() {
        return this.tookInMillis();
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards();
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field(Fields._SCROLL_ID, this.scrollId);
        }
        builder.field(Fields.TOOK, this.tookInMillis);
        builder.field(Fields.TIMED_OUT, this.timedOut());
        builder.startObject(Fields._SHARDS);
        builder.field(Fields.TOTAL, this.totalShards());
        builder.field(Fields.SUCCESSFUL, this.successfulShards());
        builder.field(Fields.FAILED, this.failedShards());
        if (this.shardFailures.length > 0) {
            builder.startArray(Fields.FAILURES);
            for (ShardSearchFailure shardFailure : this.shardFailures) {
                builder.startObject();
                if (shardFailure.shard() != null) {
                    builder.field(Fields.INDEX, shardFailure.shard().index());
                    builder.field(Fields.SHARD, shardFailure.shard().shardId());
                }
                builder.field(Fields.REASON, shardFailure.reason());
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        this.internalResponse.toXContent(builder, params);
        return builder;
    }

    public static SearchResponse readSearchResponse(StreamInput in) throws IOException {
        SearchResponse response = new SearchResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.internalResponse = InternalSearchResponse.readInternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        if (in.readBoolean()) {
            this.scrollId = in.readUTF();
        }
        this.tookInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        if (this.scrollId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.scrollId);
        }
        out.writeVLong(this.tookInMillis);
    }

    static final class Fields {
        static final XContentBuilderString _SCROLL_ID = new XContentBuilderString("_scroll_id");
        static final XContentBuilderString _SHARDS = new XContentBuilderString("_shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");

        Fields() {
        }
    }
}

