/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class MetaDataUpdateSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        this.clusterService.add(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().localNodeMaster()) {
            return;
        }
        for (final IndexMetaData indexMetaData : event.state().metaData()) {
            String autoExpandReplicas = indexMetaData.settings().get("index.auto_expand_replicas");
            if (autoExpandReplicas == null) continue;
            try {
                final int numberOfReplicas = event.state().nodes().dataNodes().size() - 1;
                int min = Integer.parseInt(autoExpandReplicas.substring(0, autoExpandReplicas.indexOf(45)));
                String sMax = autoExpandReplicas.substring(autoExpandReplicas.indexOf(45) + 1);
                int max = sMax.equals("all") ? event.state().nodes().dataNodes().size() - 1 : Integer.parseInt(sMax);
                if (numberOfReplicas == indexMetaData.numberOfReplicas() || numberOfReplicas < min || numberOfReplicas > max) continue;
                Settings settings = ImmutableSettings.settingsBuilder().put("index.number_of_replicas", numberOfReplicas).build();
                this.updateSettings(settings, new String[]{indexMetaData.index()}, new Listener(){

                    @Override
                    public void onSuccess() {
                        MetaDataUpdateSettingsService.this.logger.info("[{}] auto expanded replicas to [{}]", indexMetaData.index(), numberOfReplicas);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        MetaDataUpdateSettingsService.this.logger.warn("[{}] fail to auto expand replicas to [{}]", indexMetaData.index(), numberOfReplicas);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("[{}] failed to parse auto expand replicas", e, indexMetaData.index());
            }
        }
    }

    public void updateSettings(Settings pSettings, final String[] indices, final Listener listener) {
        ImmutableSettings.Builder updatedSettingsBuilder = ImmutableSettings.settingsBuilder();
        for (Map.Entry entry : pSettings.getAsMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith("index.")) {
                updatedSettingsBuilder.put("index." + (String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            updatedSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        final Settings settings = updatedSettingsBuilder.build();
        this.clusterService.submitStateUpdateTask("update-settings", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                try {
                    boolean changed = false;
                    String[] actualIndices = currentState.metaData().concreteIndices(indices);
                    RoutingTable.Builder routingTableBuilder = RoutingTable.newRoutingTableBuilder().routingTable(currentState.routingTable());
                    MetaData.Builder metaDataBuilder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    int updatedNumberOfReplicas = settings.getAsInt("index.number_of_replicas", -1);
                    if (updatedNumberOfReplicas != -1) {
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        changed = true;
                    }
                    if (!changed) {
                        listener.onFailure(new ElasticSearchIllegalArgumentException("No settings applied"));
                        return currentState;
                    }
                    MetaDataUpdateSettingsService.this.logger.info("Updating number_of_replicas to [{}] for indices {}", updatedNumberOfReplicas, actualIndices);
                    return ClusterState.builder().state(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder).build();
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return currentState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onSuccess();
            }
        });
    }

    public static interface Listener {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }
}

