/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.util.concurrent.NotThreadSafe;

@NotThreadSafe
public class RoutingNodes
implements Iterable<RoutingNode> {
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final RoutingTable routingTable;
    private final Map<String, RoutingNode> nodesToShards = Maps.newHashMap();
    private final List<MutableShardRouting> unassigned = Lists.newArrayList();
    private final List<MutableShardRouting> ignoredUnassigned = Lists.newArrayList();

    public RoutingNodes(MetaData metaData, ClusterBlocks blocks, RoutingTable routingTable) {
        this.metaData = metaData;
        this.blocks = blocks;
        this.routingTable = routingTable;
        HashMap nodesToShards = Maps.newHashMap();
        for (IndexRoutingTable indexRoutingTable : routingTable.indicesRouting().values()) {
            for (IndexShardRoutingTable indexShard : indexRoutingTable) {
                for (ShardRouting shard : indexShard) {
                    if (shard.assignedToNode()) {
                        List<MutableShardRouting> entries = (ArrayList<MutableShardRouting>)nodesToShards.get(shard.currentNodeId());
                        if (entries == null) {
                            entries = Lists.newArrayList();
                            nodesToShards.put(shard.currentNodeId(), entries);
                        }
                        entries.add(new MutableShardRouting(shard));
                        if (!shard.relocating()) continue;
                        entries = (List)nodesToShards.get(shard.relocatingNodeId());
                        if (entries == null) {
                            entries = Lists.newArrayList();
                            nodesToShards.put(shard.relocatingNodeId(), entries);
                        }
                        entries.add(new MutableShardRouting(shard.index(), shard.id(), shard.relocatingNodeId(), shard.currentNodeId(), shard.primary(), ShardRoutingState.INITIALIZING));
                        continue;
                    }
                    this.unassigned.add(new MutableShardRouting(shard));
                }
            }
        }
        for (Map.Entry entry : nodesToShards.entrySet()) {
            String nodeId = (String)entry.getKey();
            this.nodesToShards.put(nodeId, new RoutingNode(nodeId, (List)entry.getValue()));
        }
    }

    @Override
    public Iterator<RoutingNode> iterator() {
        return this.nodesToShards.values().iterator();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public int requiredAverageNumberOfShardsPerNode() {
        return this.metaData.totalNumberOfShards() / this.nodesToShards.size();
    }

    public boolean hasUnassigned() {
        return !this.unassigned.isEmpty();
    }

    public List<MutableShardRouting> ignoredUnassigned() {
        return this.ignoredUnassigned;
    }

    public List<MutableShardRouting> unassigned() {
        return this.unassigned;
    }

    public List<MutableShardRouting> getUnassigned() {
        return this.unassigned();
    }

    public Map<String, RoutingNode> nodesToShards() {
        return this.nodesToShards;
    }

    public Map<String, RoutingNode> getNodesToShards() {
        return this.nodesToShards();
    }

    public RoutingNode node(String nodeId) {
        return this.nodesToShards.get(nodeId);
    }

    public MutableShardRouting findPrimaryForReplica(ShardRouting shard) {
        assert (!shard.primary());
        for (RoutingNode routingNode : this.nodesToShards.values()) {
            for (MutableShardRouting shardRouting : routingNode) {
                if (!shardRouting.shardId().equals(shard.shardId()) || !shardRouting.primary()) continue;
                return shardRouting;
            }
        }
        return null;
    }

    public List<MutableShardRouting> shardsRoutingFor(ShardRouting shardRouting) {
        return this.shardsRoutingFor(shardRouting.index(), shardRouting.id());
    }

    public List<MutableShardRouting> shardsRoutingFor(String index, int shardId) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            for (MutableShardRouting shardRouting : routingNode) {
                if (!shardRouting.index().equals(index) || shardRouting.id() != shardId) continue;
                shards.add(shardRouting);
            }
        }
        for (MutableShardRouting shardRouting : this.unassigned) {
            if (!shardRouting.index().equals(index) || shardRouting.id() != shardId) continue;
            shards.add(shardRouting);
        }
        return shards;
    }

    public int numberOfShardsOfType(ShardRoutingState state) {
        int count = 0;
        for (RoutingNode routingNode : this) {
            count += routingNode.numberOfShardsWithState(state);
        }
        return count;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... state) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        return shards;
    }

    public List<RoutingNode> sortedNodesLeastToHigh() {
        return this.nodesToShardsSorted(new Comparator<RoutingNode>(){

            @Override
            public int compare(RoutingNode o1, RoutingNode o2) {
                return o1.shards().size() - o2.shards().size();
            }
        });
    }

    public List<RoutingNode> nodesToShardsSorted(Comparator<RoutingNode> comparator) {
        ArrayList<RoutingNode> nodes = new ArrayList<RoutingNode>(this.nodesToShards.values());
        if (comparator != null) {
            Collections.sort(nodes, comparator);
        }
        return nodes;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_nodes:\n");
        for (RoutingNode routingNode : this) {
            sb.append(routingNode.prettyPrint());
        }
        sb.append("---- unassigned\n");
        for (MutableShardRouting shardEntry : this.unassigned) {
            sb.append("--------").append(shardEntry.shortSummary()).append('\n');
        }
        return sb.toString();
    }
}

