/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public abstract class IndexWriters {
    private static ESLogger logger = Loggers.getLogger(IndexWriters.class);
    private static Field docWriterField;
    private static Method docWriterGetRAMUsed;
    private static Field rollbackSegmentInfosField;
    private static final boolean docWriterReflection;

    public static SegmentInfos rollbackSegmentInfos(IndexWriter writer) throws Exception {
        return (SegmentInfos)rollbackSegmentInfosField.get(writer);
    }

    public static long estimateRamSize(IndexWriter indexWriter) throws Exception {
        if (!docWriterReflection) {
            return -1L;
        }
        Object docWriter = docWriterField.get(indexWriter);
        return (Long)docWriterGetRAMUsed.invoke(docWriter, new Object[0]);
    }

    private IndexWriters() {
    }

    static {
        boolean docWriterReflectionX = false;
        try {
            docWriterField = IndexWriter.class.getDeclaredField("docWriter");
            docWriterField.setAccessible(true);
            Class<?> docWriter = IndexWriters.class.getClassLoader().loadClass("org.apache.lucene.index.DocumentsWriter");
            docWriterGetRAMUsed = docWriter.getDeclaredMethod("getRAMUsed", new Class[0]);
            docWriterGetRAMUsed.setAccessible(true);
            rollbackSegmentInfosField = IndexWriter.class.getDeclaredField("rollbackSegmentInfos");
            rollbackSegmentInfosField.setAccessible(true);
            docWriterReflectionX = true;
        }
        catch (Exception e) {
            logger.warn("Failed to doc writer fields", e, new Object[0]);
        }
        docWriterReflection = docWriterReflectionX;
    }
}

