/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.unicast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class UnicastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final DiscoveryNode[] nodes;
    private volatile DiscoveryNodesProvider nodesProvider;
    private final AtomicInteger pingIdGenerator = new AtomicInteger();
    private final Map<Integer, ConcurrentMap<DiscoveryNode, ZenPing.PingResponse>> receivedResponses = ConcurrentCollections.newConcurrentMap();
    private final Queue<ZenPing.PingResponse> temporalResponses = new LinkedTransferQueue<ZenPing.PingResponse>();
    private final CopyOnWriteArrayList<UnicastHostsProvider> hostsProviders = new CopyOnWriteArrayList();

    public UnicastZenPing(ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool, transportService, clusterName);
    }

    public UnicastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        ArrayList<String> hosts = Lists.newArrayList(this.componentSettings.getAsArray("hosts"));
        this.logger.debug("using initial hosts {}", hosts);
        ArrayList<DiscoveryNode> nodes = Lists.newArrayList();
        int idCounter = 0;
        for (String host : hosts) {
            try {
                TransportAddress[] addresses = transportService.addressesFromString(host);
                for (int i = 0; i < addresses.length && i < 5; ++i) {
                    nodes.add(new DiscoveryNode("#zen_unicast_" + ++idCounter + "#", addresses[i]));
                }
            }
            catch (Exception e) {
                throw new ElasticSearchIllegalArgumentException("Failed to resolve address for [" + host + "]", e);
            }
        }
        this.nodes = nodes.toArray(new DiscoveryNode[nodes.size()]);
        transportService.registerHandler("discovery/zen/unicast", new UnicastPingRequestHandler());
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.transportService.removeHandler("discovery/zen/unicast");
    }

    public void addHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.add(provider);
    }

    public void removeHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.remove(provider);
    }

    @Override
    public void setNodesProvider(DiscoveryNodesProvider nodesProvider) {
        this.nodesProvider = nodesProvider;
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, final TimeValue timeout) throws ElasticSearchException {
        final int id = this.pingIdGenerator.incrementAndGet();
        this.receivedResponses.put(id, new ConcurrentHashMap());
        this.sendPings(id, timeout, false);
        this.threadPool.schedule(timeout, "cached", new Runnable(){

            @Override
            public void run() {
                UnicastZenPing.this.sendPings(id, timeout, true);
                ConcurrentMap responses = (ConcurrentMap)UnicastZenPing.this.receivedResponses.remove(id);
                listener.onPing(responses.values().toArray(new ZenPing.PingResponse[responses.size()]));
            }
        });
    }

    private void sendPings(final int id, TimeValue timeout, boolean wait) {
        UnicastPingRequest pingRequest = new UnicastPingRequest();
        pingRequest.id = id;
        pingRequest.timeout = timeout;
        DiscoveryNodes discoNodes = this.nodesProvider.nodes();
        pingRequest.pingResponse = new ZenPing.PingResponse(discoNodes.localNode(), discoNodes.masterNode(), this.clusterName);
        ArrayList<DiscoveryNode> nodesToPing = Lists.newArrayList(this.nodes);
        for (UnicastHostsProvider provider : this.hostsProviders) {
            nodesToPing.addAll(provider.buildDynamicNodes());
        }
        final CountDownLatch latch = new CountDownLatch(nodesToPing.size());
        for (final DiscoveryNode node : nodesToPing) {
            boolean disconnectX;
            DiscoveryNode nodeToSendX = discoNodes.findByAddress(node.address());
            if (nodeToSendX != null) {
                disconnectX = false;
            } else {
                nodeToSendX = node;
                disconnectX = true;
            }
            final DiscoveryNode nodeToSend = nodeToSendX;
            try {
                this.transportService.connectToNode(nodeToSend);
            }
            catch (ConnectTransportException e) {
                this.logger.trace("[{}] failed to connect to {}", e, id, nodeToSend);
                latch.countDown();
                continue;
            }
            this.logger.trace("[{}] connecting to {}, disconnect[{}]", id, nodeToSend, disconnectX);
            final boolean disconnect = disconnectX;
            this.transportService.sendRequest(nodeToSend, "discovery/zen/unicast", pingRequest, TransportRequestOptions.options().withTimeout((long)((double)timeout.millis() * 1.25)), new BaseTransportResponseHandler<UnicastPingResponse>(){

                @Override
                public UnicastPingResponse newInstance() {
                    return new UnicastPingResponse();
                }

                @Override
                public String executor() {
                    return "same";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResponse(UnicastPingResponse response) {
                    UnicastZenPing.this.logger.trace("[{}] received response from {}: {}", id, nodeToSend, Arrays.toString(response.pingResponses));
                    try {
                        DiscoveryNodes discoveryNodes = UnicastZenPing.this.nodesProvider.nodes();
                        for (ZenPing.PingResponse pingResponse : response.pingResponses) {
                            if (disconnect) {
                                UnicastZenPing.this.transportService.disconnectFromNode(nodeToSend);
                            }
                            if (pingResponse.target().id().equals(discoveryNodes.localNodeId())) continue;
                            if (!pingResponse.clusterName().equals(UnicastZenPing.this.clusterName)) {
                                UnicastZenPing.this.logger.debug("[{}] filtering out response from {}, not same cluster_name [{}]", pingResponse.target(), pingResponse.clusterName().value());
                                return;
                            }
                            ConcurrentMap responses = (ConcurrentMap)UnicastZenPing.this.receivedResponses.get(response.id);
                            if (responses == null) {
                                UnicastZenPing.this.logger.warn("received ping response with no matching id [{}]", response.id);
                                continue;
                            }
                            responses.put(pingResponse.target(), pingResponse);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    latch.countDown();
                    if (exp instanceof ConnectTransportException) {
                        UnicastZenPing.this.logger.trace("failed to connect to {}", exp, nodeToSend);
                    } else {
                        if (disconnect) {
                            UnicastZenPing.this.transportService.disconnectFromNode(nodeToSend);
                        }
                        UnicastZenPing.this.logger.warn("failed to send ping to [{}]", exp, node);
                    }
                }
            });
        }
        if (wait) {
            try {
                latch.await(timeout.millis() * 5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private UnicastPingResponse handlePingRequest(final UnicastPingRequest request) {
        this.temporalResponses.add(request.pingResponse);
        this.threadPool.schedule(TimeValue.timeValueMillis(request.timeout.millis() * 2L), "same", new Runnable(){

            @Override
            public void run() {
                UnicastZenPing.this.temporalResponses.remove(request.pingResponse);
            }
        });
        ArrayList<ZenPing.PingResponse> pingResponses = Lists.newArrayList(this.temporalResponses);
        DiscoveryNodes discoNodes = this.nodesProvider.nodes();
        pingResponses.add(new ZenPing.PingResponse(discoNodes.localNode(), discoNodes.masterNode(), this.clusterName));
        UnicastPingResponse unicastPingResponse = new UnicastPingResponse();
        unicastPingResponse.id = request.id;
        unicastPingResponse.pingResponses = pingResponses.toArray(new ZenPing.PingResponse[pingResponses.size()]);
        return unicastPingResponse;
    }

    static class UnicastPingResponse
    implements Streamable {
        int id;
        ZenPing.PingResponse[] pingResponses;

        UnicastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.pingResponses = new ZenPing.PingResponse[in.readVInt()];
            for (int i = 0; i < this.pingResponses.length; ++i) {
                this.pingResponses[i] = ZenPing.PingResponse.readPingResponse(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeVInt(this.pingResponses.length);
            for (ZenPing.PingResponse pingResponse : this.pingResponses) {
                pingResponse.writeTo(out);
            }
        }
    }

    static class UnicastPingRequest
    implements Streamable {
        int id;
        TimeValue timeout;
        ZenPing.PingResponse pingResponse;

        UnicastPingRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.timeout = TimeValue.readTimeValue(in);
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            this.timeout.writeTo(out);
            this.pingResponse.writeTo(out);
        }
    }

    class UnicastPingRequestHandler
    extends BaseTransportRequestHandler<UnicastPingRequest> {
        static final String ACTION = "discovery/zen/unicast";

        UnicastPingRequestHandler() {
        }

        @Override
        public UnicastPingRequest newInstance() {
            return new UnicastPingRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(UnicastPingRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(UnicastZenPing.this.handlePingRequest(request));
        }
    }
}

