/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.phonetic;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.common.codec.Encoder;

public class PhoneticFilter
extends TokenFilter {
    protected boolean inject = true;
    protected Encoder encoder = null;
    protected String name = null;
    protected AttributeSource.State save = null;
    private final TermAttribute termAtt;
    private final PositionIncrementAttribute posAtt;

    public PhoneticFilter(TokenStream in, Encoder encoder, String name, boolean inject) {
        super(in);
        this.encoder = encoder;
        this.name = name;
        this.inject = inject;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.save != null) {
            this.restoreState(this.save);
            this.save = null;
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.termAtt.termLength() == 0) {
            return true;
        }
        String value = this.termAtt.term();
        String phonetic = null;
        try {
            String v = this.encoder.encode(value).toString();
            if (v.length() > 0 && !value.equals(v)) {
                phonetic = v;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (phonetic == null) {
            return true;
        }
        if (!this.inject) {
            this.termAtt.setTermBuffer(phonetic);
            return true;
        }
        int origOffset = this.posAtt.getPositionIncrement();
        this.posAtt.setPositionIncrement(0);
        this.save = this.captureState();
        this.posAtt.setPositionIncrement(origOffset);
        this.termAtt.setTermBuffer(phonetic);
        return true;
    }

    public void reset() throws IOException {
        this.input.reset();
        this.save = null;
    }
}

