/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.IncludeInAllMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.MultiFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.RootObjectMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;

@ThreadSafe
public class ObjectMapper
implements XContentMapper,
IncludeInAllMapper {
    public static final String CONTENT_TYPE = "object";
    private final String name;
    private final boolean enabled;
    private final Dynamic dynamic;
    private final ContentPath.Type pathType;
    private Boolean includeInAll;
    private volatile ImmutableMap<String, XContentMapper> mappers = ImmutableMap.of();
    private final Object mutex = new Object();

    protected ObjectMapper(String name) {
        this(name, true, Defaults.DYNAMIC, Defaults.PATH_TYPE);
    }

    protected ObjectMapper(String name, boolean enabled, Dynamic dynamic, ContentPath.Type pathType) {
        this(name, enabled, dynamic, pathType, null);
    }

    ObjectMapper(String name, boolean enabled, Dynamic dynamic, ContentPath.Type pathType, Map<String, XContentMapper> mappers) {
        this.name = name;
        this.enabled = enabled;
        this.dynamic = dynamic;
        this.pathType = pathType;
        if (mappers != null) {
            this.mappers = ImmutableMap.copyOf(mappers);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll == null) {
            return;
        }
        this.includeInAll = includeInAll;
        for (XContentMapper mapper : this.mappers.values()) {
            if (!(mapper instanceof IncludeInAllMapper)) continue;
            ((IncludeInAllMapper)mapper).includeInAll(includeInAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper putMapper(XContentMapper mapper) {
        if (mapper instanceof IncludeInAllMapper) {
            ((IncludeInAllMapper)mapper).includeInAll(this.includeInAll);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mapper.name(), mapper).immutableMap();
        }
        return this;
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        for (XContentMapper mapper : this.mappers.values()) {
            mapper.traverse(fieldMapperListener);
        }
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        if (!this.enabled) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        String currentFieldName = parser.currentName();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(context, currentFieldName);
            } else if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(context, currentFieldName);
            } else if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NULL) {
                this.serializeNullValue(context, currentFieldName);
            } else if (token.isValue()) {
                this.serializeValue(context, currentFieldName, token);
            }
            token = parser.nextToken();
        }
        context.path().pathType(origPathType);
    }

    private void serializeNullValue(ParseContext context, String lastFieldName) throws IOException {
        XContentMapper mapper = this.mappers.get(lastFieldName);
        if (mapper != null) {
            mapper.parse(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeObject(ParseContext context, String currentFieldName) throws IOException {
        context.path().add(currentFieldName);
        XContentMapper objectMapper = this.mappers.get(currentFieldName);
        if (objectMapper != null) {
            objectMapper.parse(context);
        } else {
            Dynamic dynamic = this.dynamic;
            if (dynamic == null) {
                dynamic = context.root().dynamic();
            }
            if (dynamic == Dynamic.STRICT) {
                throw new StrictDynamicMappingException(currentFieldName);
            }
            if (dynamic == Dynamic.TRUE) {
                Object object = this.mutex;
                synchronized (object) {
                    objectMapper = this.mappers.get(currentFieldName);
                    if (objectMapper != null) {
                        objectMapper.parse(context);
                    } else {
                        XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, CONTENT_TYPE);
                        if (builder == null) {
                            builder = ((Builder)((Builder)XContentMapperBuilders.object(currentFieldName).enabled(true)).dynamic(dynamic)).pathType(this.pathType);
                        }
                        context.path().remove();
                        XContentMapper.BuilderContext builderContext = new XContentMapper.BuilderContext(context.path());
                        objectMapper = builder.build(builderContext);
                        this.putMapper(objectMapper);
                        context.path().add(currentFieldName);
                        objectMapper.parse(context);
                        context.addedMapper();
                    }
                }
            } else {
                context.parser().skipChildren();
            }
        }
        context.path().remove();
    }

    private void serializeArray(ParseContext context, String lastFieldName) throws IOException {
        XContentMapper mapper = this.mappers.get(lastFieldName);
        if (mapper != null && mapper instanceof ArrayValueMapperParser) {
            mapper.parse(context);
        } else {
            XContentParser.Token token;
            XContentParser parser = context.parser();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    this.serializeObject(context, lastFieldName);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    this.serializeArray(context, lastFieldName);
                    continue;
                }
                if (token == XContentParser.Token.FIELD_NAME) {
                    lastFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NULL) {
                    this.serializeNullValue(context, lastFieldName);
                    continue;
                }
                this.serializeValue(context, lastFieldName, token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeValue(final ParseContext context, String currentFieldName, XContentParser.Token token) throws IOException {
        XContentMapper mapper = this.mappers.get(currentFieldName);
        if (mapper != null) {
            mapper.parse(context);
            return;
        }
        Dynamic dynamic = this.dynamic;
        if (dynamic == null) {
            dynamic = context.root().dynamic();
        }
        if (dynamic == Dynamic.STRICT) {
            throw new StrictDynamicMappingException(currentFieldName);
        }
        if (dynamic == Dynamic.FALSE) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            mapper = this.mappers.get(currentFieldName);
            if (mapper != null) {
                mapper.parse(context);
                return;
            }
            XContentMapper.BuilderContext builderContext = new XContentMapper.BuilderContext(context.path());
            if (token == XContentParser.Token.VALUE_STRING) {
                String text = context.parser().text();
                boolean resolved = false;
                if (text.contains(":") || text.contains("-") || text.contains("/")) {
                    for (FormatDateTimeFormatter dateTimeFormatter : context.root().dateTimeFormatters()) {
                        try {
                            dateTimeFormatter.parser().parseMillis(text);
                            XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "date");
                            if (builder == null) {
                                builder = XContentMapperBuilders.dateField(currentFieldName).dateTimeFormatter(dateTimeFormatter);
                            }
                            mapper = builder.build(builderContext);
                            resolved = true;
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                }
                if (!resolved) {
                    XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "string");
                    if (builder == null) {
                        builder = XContentMapperBuilders.stringField(currentFieldName);
                    }
                    mapper = builder.build(builderContext);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                XContentParser.NumberType numberType = context.parser().numberType();
                if (numberType == XContentParser.NumberType.INT) {
                    if (context.parser().estimatedNumberType()) {
                        XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                        if (builder == null) {
                            builder = XContentMapperBuilders.longField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    } else {
                        XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "integer");
                        if (builder == null) {
                            builder = XContentMapperBuilders.integerField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    }
                } else if (numberType == XContentParser.NumberType.LONG) {
                    XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                    if (builder == null) {
                        builder = XContentMapperBuilders.longField(currentFieldName);
                    }
                    mapper = builder.build(builderContext);
                } else if (numberType == XContentParser.NumberType.FLOAT) {
                    if (context.parser().estimatedNumberType()) {
                        XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                        if (builder == null) {
                            builder = XContentMapperBuilders.doubleField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    } else {
                        XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "float");
                        if (builder == null) {
                            builder = XContentMapperBuilders.floatField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    }
                } else if (numberType == XContentParser.NumberType.DOUBLE) {
                    XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                    if (builder == null) {
                        builder = XContentMapperBuilders.doubleField(currentFieldName);
                    }
                    mapper = builder.build(builderContext);
                }
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "boolean");
                if (builder == null) {
                    builder = XContentMapperBuilders.booleanField(currentFieldName);
                }
                mapper = builder.build(builderContext);
            } else {
                XContentMapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, null);
                if (builder != null) {
                    mapper = builder.build(builderContext);
                } else {
                    throw new ElasticSearchIllegalStateException("Can't handle serializing a dynamic type with content token [" + (Object)((Object)token) + "] and field name [" + currentFieldName + "]");
                }
            }
            this.putMapper(mapper);
            mapper.traverse(new FieldMapperListener(){

                @Override
                public void fieldMapper(FieldMapper fieldMapper) {
                    context.docMapper().addFieldMapper(fieldMapper);
                }
            });
            mapper.parse(context);
            context.addedMapper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!(mergeWith instanceof ObjectMapper)) {
            mergeContext.addConflict("Can't merge a non object mapping [" + mergeWith.name() + "] with an object mapping [" + this.name() + "]");
            return;
        }
        ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
        this.doMerge(mergeWithObject, mergeContext);
        Object object = this.mutex;
        synchronized (object) {
            for (XContentMapper mergeWithMapper : mergeWithObject.mappers.values()) {
                XContentMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.name());
                if (mergeIntoMapper == null) {
                    if (mergeContext.mergeFlags().simulate()) continue;
                    this.putMapper(mergeWithMapper);
                    if (!(mergeWithMapper instanceof AbstractFieldMapper)) continue;
                    mergeContext.docMapper().addFieldMapper((FieldMapper)((Object)mergeWithMapper));
                    continue;
                }
                if (mergeWithMapper instanceof MultiFieldMapper && !(mergeIntoMapper instanceof MultiFieldMapper)) {
                    MultiFieldMapper mergeWithMultiField = (MultiFieldMapper)mergeWithMapper;
                    mergeWithMultiField.merge(mergeIntoMapper, mergeContext);
                    if (mergeContext.mergeFlags().simulate()) continue;
                    this.putMapper(mergeWithMultiField);
                    for (XContentMapper mapper : mergeWithMultiField.mappers().values()) {
                        if (!(mapper instanceof AbstractFieldMapper)) continue;
                        mergeContext.docMapper().addFieldMapper((FieldMapper)((Object)mapper));
                    }
                    continue;
                }
                mergeIntoMapper.merge(mergeWithMapper, mergeContext);
            }
        }
    }

    protected void doMerge(ObjectMapper mergeWith, MergeContext mergeContext) {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null, XContentMapper.EMPTY_ARRAY);
        return builder;
    }

    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom, XContentMapper ... additionalMappers) throws IOException {
        builder.startObject(this.name);
        if (this.mappers.isEmpty()) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this instanceof RootObjectMapper) {
            if (this.dynamic != Dynamic.TRUE) {
                builder.field("dynamic", this.dynamic.name().toLowerCase());
            }
        } else if (this.dynamic != Defaults.DYNAMIC) {
            builder.field("dynamic", this.dynamic.name().toLowerCase());
        }
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        TreeMap<String, XContentMapper> sortedMappers = new TreeMap<String, XContentMapper>(this.mappers);
        for (XContentMapper mapper : sortedMappers.values()) {
            if (!(mapper instanceof InternalMapper)) continue;
            mapper.toXContent(builder, params);
        }
        if (additionalMappers != null) {
            for (XContentMapper mapper : additionalMappers) {
                mapper.toXContent(builder, params);
            }
        }
        if (!this.mappers.isEmpty()) {
            builder.startObject("properties");
            for (XContentMapper mapper : sortedMappers.values()) {
                if (mapper instanceof InternalMapper) continue;
                mapper.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Map<String, Object> objectNode = node;
            Builder builder = this.createBuilder(name);
            for (Map.Entry<String, Object> entry : objectNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("dynamic")) {
                    String value = fieldNode.toString();
                    if (value.equalsIgnoreCase("strict")) {
                        builder.dynamic(Dynamic.STRICT);
                        continue;
                    }
                    builder.dynamic(XContentMapValues.nodeBooleanValue(fieldNode) ? Dynamic.TRUE : Dynamic.FALSE);
                    continue;
                }
                if (fieldName.equals("type")) {
                    String type = fieldNode.toString();
                    if (type.equals(ObjectMapper.CONTENT_TYPE)) continue;
                    throw new MapperParsingException("Trying to parse an object but has a different type [" + type + "] for [" + name + "]");
                }
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("path")) {
                    builder.pathType(XContentTypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("properties")) {
                    this.parseProperties(builder, (Map)fieldNode, parserContext);
                    continue;
                }
                if (fieldName.equals("include_in_all")) {
                    builder.includeInAll(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                this.processField(builder, fieldName, fieldNode);
            }
            return builder;
        }

        private void parseProperties(Builder objBuilder, Map<String, Object> propsNode, XContentMapper.TypeParser.ParserContext parserContext) {
            for (Map.Entry<String, Object> entry : propsNode.entrySet()) {
                String type;
                String propName = entry.getKey();
                Map propNode = (Map)entry.getValue();
                Object typeNode = propNode.get("type");
                if (typeNode != null) {
                    type = typeNode.toString();
                } else if (propNode.get("properties") != null) {
                    type = ObjectMapper.CONTENT_TYPE;
                } else if (propNode.get("fields") != null) {
                    type = "multi_field";
                } else {
                    throw new MapperParsingException("No type specified for property [" + propName + "]");
                }
                XContentMapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + propName + "]");
                }
                objBuilder.add(typeParser.parse(propName, propNode, parserContext));
            }
        }

        protected Builder createBuilder(String name) {
            return XContentMapperBuilders.object(name);
        }

        protected void processField(Builder builder, String fieldName, Object fieldNode) {
        }
    }

    public static class Builder<T extends Builder, Y extends ObjectMapper>
    extends XContentMapper.Builder<T, Y> {
        protected boolean enabled = true;
        protected Dynamic dynamic = Defaults.DYNAMIC;
        protected ContentPath.Type pathType = Defaults.PATH_TYPE;
        protected Boolean includeInAll;
        protected final List<XContentMapper.Builder> mappersBuilders = Lists.newArrayList();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public T enabled(boolean enabled) {
            this.enabled = enabled;
            return (T)((Builder)this.builder);
        }

        public T dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return (T)((Builder)this.builder);
        }

        public T pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return (T)((Builder)this.builder);
        }

        public T includeInAll(boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T add(XContentMapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return (T)((Builder)this.builder);
        }

        @Override
        public Y build(XContentMapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            context.path().add(this.name);
            HashMap<String, XContentMapper> mappers = new HashMap<String, XContentMapper>();
            for (XContentMapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                mappers.put(mapper.name(), (XContentMapper)mapper);
            }
            ObjectMapper objectMapper = this.createMapper(this.name, this.enabled, this.dynamic, this.pathType, mappers);
            context.path().pathType(origPathType);
            context.path().remove();
            objectMapper.includeInAll(this.includeInAll);
            return (Y)objectMapper;
        }

        protected ObjectMapper createMapper(String name, boolean enabled, Dynamic dynamic, ContentPath.Type pathType, Map<String, XContentMapper> mappers) {
            return new ObjectMapper(name, enabled, dynamic, pathType, mappers);
        }
    }

    public static enum Dynamic {
        TRUE,
        FALSE,
        STRICT;

    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Dynamic DYNAMIC = null;
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

