/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.elasticsearch.common.Digest;
import org.elasticsearch.common.Hex;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.lucene.Directories;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public abstract class AbstractStore
extends AbstractIndexShardComponent
implements Store {
    protected final IndexStore indexStore;
    private volatile ImmutableMap<String, StoreFileMetaData> filesMetadata = ImmutableMap.of();
    private volatile String[] files = Strings.EMPTY_ARRAY;
    private final Object mutex = new Object();
    private final boolean sync;

    protected AbstractStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) {
        super(shardId, indexSettings);
        this.indexStore = indexStore;
        this.sync = this.componentSettings.getAsBoolean("sync", true);
    }

    protected Directory wrapDirectory(Directory dir) throws IOException {
        return new StoreDirectory(dir);
    }

    @Override
    public ImmutableMap<String, StoreFileMetaData> list() throws IOException {
        ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
        for (String name : this.files) {
            StoreFileMetaData md = this.metaData(name);
            if (md == null) continue;
            builder.put(md.name(), md);
        }
        return builder.build();
    }

    @Override
    public StoreFileMetaData metaData(String name) throws IOException {
        StoreFileMetaData md = this.filesMetadata.get(name);
        if (md == null) {
            return null;
        }
        if (md.lastModified() == -1L || md.length() == -1L) {
            return null;
        }
        return md;
    }

    @Override
    public void deleteContent() throws IOException {
        Directories.deleteFiles(this.directory());
    }

    @Override
    public void fullDelete() throws IOException {
        this.deleteContent();
    }

    @Override
    public ByteSizeValue estimateSize() throws IOException {
        return Directories.estimateSize(this.directory());
    }

    @Override
    public boolean suggestUseCompoundFile() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.directory().close();
    }

    @Override
    public IndexOutput createOutputWithNoChecksum(String name) throws IOException {
        return ((StoreDirectory)this.directory()).createOutput(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeChecksum(String name, String checksum) throws IOException {
        IndexOutput checkSumOutput = ((StoreDirectory)this.directory()).delegate().createOutput(name + ".cks");
        byte[] checksumBytes = Unicode.fromStringAsBytes(checksum);
        checkSumOutput.writeBytes(checksumBytes, checksumBytes.length);
        checkSumOutput.close();
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData metaData = this.filesMetadata.get(name);
            metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.lastModified(), checksum);
            this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).put(name, metaData).immutableMap();
        }
    }

    static /* synthetic */ String[] access$202(AbstractStore x0, String[] x1) {
        x0.files = x1;
        return x1;
    }

    class StoreIndexOutput
    extends IndexOutput {
        private final IndexOutput delegate;
        private final String name;
        private final MessageDigest digest;

        StoreIndexOutput(IndexOutput delegate, String name, boolean computeChecksum) {
            this.delegate = delegate;
            this.name = name;
            this.digest = computeChecksum ? ("segments.gen".equals(name) ? null : (name.startsWith("segments") ? null : Digest.getMd5Digest())) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.delegate.close();
            String checksum = null;
            if (this.digest != null) {
                checksum = Hex.encodeHexString(this.digest.digest());
                IndexOutput checkSumOutput = ((StoreDirectory)AbstractStore.this.directory()).delegate().createOutput(this.name + ".cks");
                byte[] checksumBytes = Unicode.fromStringAsBytes(checksum);
                checkSumOutput.writeBytes(checksumBytes, checksumBytes.length);
                checkSumOutput.close();
            }
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                StoreFileMetaData md = new StoreFileMetaData(this.name, AbstractStore.this.directory().fileLength(this.name), AbstractStore.this.directory().fileModified(this.name), checksum);
                AbstractStore.this.filesMetadata = MapBuilder.newMapBuilder(AbstractStore.this.filesMetadata).put(this.name, md).immutableMap();
                AbstractStore.access$202(AbstractStore.this, ((ImmutableCollection)((Object)AbstractStore.this.filesMetadata.keySet())).toArray(new String[AbstractStore.this.filesMetadata.size()]));
            }
        }

        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
            if (this.digest != null) {
                this.digest.update(b);
            }
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
            if (this.digest != null) {
                this.digest.update(b, offset, length);
            }
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public long getFilePointer() {
            return this.delegate.getFilePointer();
        }

        public void seek(long pos) throws IOException {
            this.delegate.seek(pos);
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public void setLength(long length) throws IOException {
            this.delegate.setLength(length);
        }

        public void writeStringStringMap(Map<String, String> map) throws IOException {
            this.delegate.writeStringStringMap(map);
        }
    }

    class StoreDirectory
    extends Directory
    implements ForceSyncDirectory {
        private final Directory delegate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoreDirectory(Directory delegate) throws IOException {
            this.delegate = delegate;
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                MapBuilder<String, StoreFileMetaData> builder = MapBuilder.newMapBuilder();
                for (String file : delegate.listAll()) {
                    if (file.endsWith(".cks")) continue;
                    String checksum = null;
                    if (delegate.fileExists(file + ".cks")) {
                        IndexInput indexInput = delegate.openInput(file + ".cks");
                        try {
                            if (indexInput.length() > 0L) {
                                byte[] checksumBytes = new byte[(int)indexInput.length()];
                                indexInput.readBytes(checksumBytes, 0, checksumBytes.length, false);
                                checksum = Unicode.fromBytes(checksumBytes);
                            }
                        }
                        finally {
                            indexInput.close();
                        }
                    }
                    builder.put(file, new StoreFileMetaData(file, delegate.fileLength(file), delegate.fileModified(file), checksum));
                }
                AbstractStore.this.filesMetadata = builder.immutableMap();
                AbstractStore.access$202(AbstractStore.this, ((ImmutableCollection)((Object)AbstractStore.this.filesMetadata.keySet())).toArray(new String[AbstractStore.this.filesMetadata.size()]));
            }
        }

        public Directory delegate() {
            return this.delegate;
        }

        public String[] listAll() throws IOException {
            return AbstractStore.this.files;
        }

        public boolean fileExists(String name) throws IOException {
            return AbstractStore.this.filesMetadata.containsKey(name);
        }

        public long fileModified(String name) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)AbstractStore.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (metaData.lastModified() != -1L) {
                return metaData.lastModified();
            }
            return this.delegate.fileModified(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touchFile(String name) throws IOException {
            this.delegate.touchFile(name);
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                StoreFileMetaData metaData = (StoreFileMetaData)AbstractStore.this.filesMetadata.get(name);
                if (metaData != null) {
                    metaData = new StoreFileMetaData(metaData.name(), metaData.length(), this.delegate.fileModified(name), metaData.checksum());
                    AbstractStore.this.filesMetadata = MapBuilder.newMapBuilder(AbstractStore.this.filesMetadata).put(name, metaData).immutableMap();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFile(String name) throws IOException {
            this.delegate.deleteFile(name);
            try {
                this.delegate.deleteFile(name + ".cks");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                AbstractStore.this.filesMetadata = MapBuilder.newMapBuilder(AbstractStore.this.filesMetadata).remove(name).immutableMap();
                AbstractStore.access$202(AbstractStore.this, ((ImmutableCollection)((Object)AbstractStore.this.filesMetadata.keySet())).toArray(new String[AbstractStore.this.filesMetadata.size()]));
            }
        }

        public long fileLength(String name) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)AbstractStore.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (metaData.length() != -1L) {
                return metaData.length();
            }
            return this.delegate.fileLength(name);
        }

        public IndexOutput createOutput(String name) throws IOException {
            return this.createOutput(name, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexOutput createOutput(String name, boolean computeChecksum) throws IOException {
            IndexOutput out = this.delegate.createOutput(name);
            if (AbstractStore.this.filesMetadata.containsKey(name)) {
                try {
                    this.delegate.deleteFile(name + ".cks");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                StoreFileMetaData metaData = new StoreFileMetaData(name, -1L, -1L, null);
                AbstractStore.this.filesMetadata = MapBuilder.newMapBuilder(AbstractStore.this.filesMetadata).put(name, metaData).immutableMap();
                AbstractStore.access$202(AbstractStore.this, ((ImmutableCollection)((Object)AbstractStore.this.filesMetadata.keySet())).toArray(new String[AbstractStore.this.filesMetadata.size()]));
            }
            return new StoreIndexOutput(out, name, computeChecksum);
        }

        public IndexInput openInput(String name) throws IOException {
            return this.delegate.openInput(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.delegate.close();
            Object object = AbstractStore.this.mutex;
            synchronized (object) {
                AbstractStore.this.filesMetadata = ImmutableMap.of();
                AbstractStore.access$202(AbstractStore.this, Strings.EMPTY_ARRAY);
            }
        }

        public Lock makeLock(String name) {
            return this.delegate.makeLock(name);
        }

        public IndexInput openInput(String name, int bufferSize) throws IOException {
            return this.delegate.openInput(name, bufferSize);
        }

        public void clearLock(String name) throws IOException {
            this.delegate.clearLock(name);
        }

        public void setLockFactory(LockFactory lockFactory) {
            this.delegate.setLockFactory(lockFactory);
        }

        public LockFactory getLockFactory() {
            return this.delegate.getLockFactory();
        }

        public String getLockID() {
            return this.delegate.getLockID();
        }

        public void sync(String name) throws IOException {
            if (AbstractStore.this.sync) {
                this.delegate.sync(name);
            }
        }

        @Override
        public void forceSync(String name) throws IOException {
            this.delegate.sync(name);
        }
    }
}

