/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.facet.FacetParseElement;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.FacetProcessors;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacetProcessor;
import org.elasticsearch.search.facet.filter.FilterFacetProcessor;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetProcessor;
import org.elasticsearch.search.facet.histogram.HistogramFacetProcessor;
import org.elasticsearch.search.facet.query.QueryFacetProcessor;
import org.elasticsearch.search.facet.range.RangeFacetProcessor;
import org.elasticsearch.search.facet.statistical.StatisticalFacetProcessor;
import org.elasticsearch.search.facet.terms.TermsFacetProcessor;

public class FacetModule
extends AbstractModule {
    private List<Class<? extends FacetProcessor>> processors = Lists.newArrayList();

    public FacetModule() {
        this.processors.add(FilterFacetProcessor.class);
        this.processors.add(QueryFacetProcessor.class);
        this.processors.add(GeoDistanceFacetProcessor.class);
        this.processors.add(HistogramFacetProcessor.class);
        this.processors.add(DateHistogramFacetProcessor.class);
        this.processors.add(RangeFacetProcessor.class);
        this.processors.add(StatisticalFacetProcessor.class);
        this.processors.add(TermsFacetProcessor.class);
    }

    public void addFacetProcessor(Class<? extends FacetProcessor> facetProcessor) {
        this.processors.add(facetProcessor);
    }

    @Override
    protected void configure() {
        Multibinder<FacetProcessor> multibinder = Multibinder.newSetBinder(this.binder(), FacetProcessor.class);
        for (Class<? extends FacetProcessor> processor : this.processors) {
            multibinder.addBinding().to(processor);
        }
        this.bind(FacetProcessors.class).asEagerSingleton();
        this.bind(FacetParseElement.class).asEagerSingleton();
        this.bind(FacetPhase.class).asEagerSingleton();
    }
}

