/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TAdvancingIterator;
import org.elasticsearch.common.trove.iterator.TLongLongIterator;
import org.elasticsearch.common.trove.map.hash.TLongDoubleHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalCountAndTotalDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final String STREAM_TYPE = "ctdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalCountAndTotalDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    private DateHistogramFacet.ComparatorType comparatorType;
    TLongLongHashMap counts;
    TLongDoubleHashMap totals;
    CountAndTotalEntry[] entries = null;
    static final TLongLongHashMap EMPTY_LONG_LONG_MAP = new TLongLongHashMap();
    static final TLongDoubleHashMap EMPTY_LONG_DOUBLE_MAP = new TLongDoubleHashMap();

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalCountAndTotalDateHistogramFacet() {
    }

    public InternalCountAndTotalDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, TLongLongHashMap counts, TLongDoubleHashMap totals) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.counts = counts;
        this.totals = totals;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "date_histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<CountAndTotalEntry> entries() {
        return Arrays.asList(this.computeEntries());
    }

    public List<CountAndTotalEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    private CountAndTotalEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountAndTotalEntry[this.counts.size()];
        int i = 0;
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            this.entries[i++] = new CountAndTotalEntry(it.key(), it.value(), this.totals.get(it.key()));
        }
        Arrays.sort(this.entries, this.comparatorType.comparator());
        return this.entries;
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        TLongLongHashMap counts = null;
        TLongDoubleHashMap totals = null;
        InternalCountAndTotalDateHistogramFacet firstHistoFacet = (InternalCountAndTotalDateHistogramFacet)facets.get(0);
        for (Facet facet : facets) {
            TAdvancingIterator it;
            InternalCountAndTotalDateHistogramFacet histoFacet = (InternalCountAndTotalDateHistogramFacet)facet;
            if (!histoFacet.counts.isEmpty()) {
                if (counts == null) {
                    counts = histoFacet.counts;
                } else {
                    it = histoFacet.counts.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        counts.adjustOrPutValue(it.key(), it.value(), it.value());
                    }
                }
            }
            if (histoFacet.totals.isEmpty()) continue;
            if (totals == null) {
                totals = histoFacet.totals;
                continue;
            }
            it = histoFacet.totals.iterator();
            while (it.hasNext()) {
                it.advance();
                totals.adjustOrPutValue(it.key(), it.value(), it.value());
            }
        }
        if (counts == null) {
            counts = EMPTY_LONG_LONG_MAP;
        }
        if (totals == null) {
            totals = EMPTY_LONG_DOUBLE_MAP;
        }
        firstHistoFacet.counts = counts;
        firstHistoFacet.totals = totals;
        return firstHistoFacet;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountAndTotalEntry entry : this.computeEntries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.time());
            builder.field(Fields.COUNT, entry.count());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountAndTotalDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountAndTotalDateHistogramFacet facet = new InternalCountAndTotalDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        int size = in.readVInt();
        if (size == 0) {
            this.counts = EMPTY_LONG_LONG_MAP;
            this.totals = EMPTY_LONG_DOUBLE_MAP;
        } else {
            this.counts = new TLongLongHashMap(size);
            this.totals = new TLongDoubleHashMap(size);
            for (int i = 0; i < size; ++i) {
                long key = in.readLong();
                this.counts.put(key, in.readVLong());
                this.totals.put(key, in.readDouble());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.counts.size());
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeLong(it.key());
            out.writeVLong(it.value());
            out.writeDouble(this.totals.get(it.key()));
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");

        Fields() {
        }
    }

    public class CountAndTotalEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        private final long count;
        private final double total;

        public CountAndTotalEntry(long time, long count, double total) {
            this.time = time;
            this.count = count;
            this.total = total;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long getTime() {
            return this.time();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public double mean() {
            return this.total / (double)this.count;
        }

        @Override
        public double getMean() {
            return this.mean();
        }
    }
}

