/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import play.Play;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.Transformer;

public abstract class ElasticSearch {
    public static Client client() {
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        return plugin.client();
    }

    public static <T extends Model> SearchResults search(XContentQueryBuilder queryBuilder, Class<T> clazz) {
        String index = ElasticSearchAdapter.getIndexName(clazz);
        SearchResponse searchResponse = (SearchResponse)ElasticSearch.client().prepareSearch(new String[]{index}).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery(queryBuilder).execute().actionGet();
        SearchResults<T> searchResults = Transformer.toSearchResults(searchResponse, clazz);
        return searchResults;
    }

    public static <T extends Model> SearchResults search(XContentQueryBuilder queryBuilder, Class<T> clazz, AbstractFacetBuilder ... facets) {
        String index = ElasticSearchAdapter.getIndexName(clazz);
        SearchRequestBuilder builder = ElasticSearch.client().prepareSearch(new String[]{index}).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery(queryBuilder);
        for (AbstractFacetBuilder facet : facets) {
            builder.addFacet(facet);
        }
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        SearchResults<T> searchResults = Transformer.toSearchResults(searchResponse, clazz);
        return searchResults;
    }
}

