/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import org.elasticsearch.ElasticSearchWrapperException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public final class ExceptionsHelper {
    private static final ESLogger logger = Loggers.getLogger(ExceptionsHelper.class);

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof ElasticSearchWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t, new Object[0]);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    public static String detailedMessage(Throwable t) {
        return ExceptionsHelper.detailedMessage(t, false, 0);
    }

    public static String detailedMessage(Throwable t, boolean newLines, int initialCounter) {
        if (t == null) {
            return "Unknown";
        }
        int counter = initialCounter + 1;
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                if (t.getMessage() != null) {
                    sb.append(t.getClass().getSimpleName()).append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                    if (!newLines) {
                        sb.append("; ");
                    }
                }
                if ((t = t.getCause()) != null) {
                    if (newLines) {
                        sb.append("\n");
                        for (int i = 0; i < counter; ++i) {
                            sb.append("\t");
                        }
                    } else {
                        sb.append("nested: ");
                    }
                }
                ++counter;
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }
}

