/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportService;

public class TransportClientNodesService
extends AbstractComponent {
    private final TimeValue nodesSamplerInterval;
    private final ClusterName clusterName;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private volatile ImmutableList<DiscoveryNode> listedNodes = ImmutableList.of();
    private final Object transportMutex = new Object();
    private volatile ImmutableList<DiscoveryNode> nodes = ImmutableList.of();
    private final AtomicInteger tempNodeIdGenerator = new AtomicInteger();
    private final Runnable nodesSampler;
    private volatile ScheduledFuture nodesSamplerFuture;
    private final AtomicInteger randomNodeGenerator = new AtomicInteger();
    private volatile boolean closed;

    @Inject
    public TransportClientNodesService(Settings settings, ClusterName clusterName, TransportService transportService, ThreadPool threadPool) {
        super(settings);
        this.clusterName = clusterName;
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.nodesSamplerInterval = this.componentSettings.getAsTime("nodes_sampler_interval", TimeValue.timeValueSeconds(5L));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("node_sampler_interval[" + this.nodesSamplerInterval + "]", new Object[0]);
        }
        this.nodesSampler = this.componentSettings.getAsBoolean("sniff", false) != false ? new ScheduledSniffNodesSampler() : new ScheduledConnectNodeSampler();
        this.nodesSamplerFuture = threadPool.schedule(this.nodesSamplerInterval, "cached", this.nodesSampler);
        transportService.throwConnectException(true);
    }

    public ImmutableList<TransportAddress> transportAddresses() {
        ImmutableList.Builder lstBuilder = ImmutableList.builder();
        for (DiscoveryNode listedNode : this.listedNodes) {
            lstBuilder.add(listedNode.address());
        }
        return lstBuilder.build();
    }

    public ImmutableList<DiscoveryNode> connectedNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService addTransportAddress(TransportAddress transportAddress) {
        Object object = this.transportMutex;
        synchronized (object) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.listedNodes = ((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(this.listedNodes)).add(new DiscoveryNode("#transport#-" + this.tempNodeIdGenerator.incrementAndGet(), transportAddress))).build();
        }
        this.nodesSampler.run();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService removeTransportAddress(TransportAddress transportAddress) {
        Object object = this.transportMutex;
        synchronized (object) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DiscoveryNode otherNode : this.listedNodes) {
                if (otherNode.address().equals(transportAddress)) continue;
                builder.add(otherNode);
            }
            this.listedNodes = builder.build();
        }
        this.nodesSampler.run();
        return this;
    }

    public <T> T execute(NodeCallback<T> callback) throws ElasticSearchException {
        ImmutableList<DiscoveryNode> nodes = this.nodes;
        if (nodes.isEmpty()) {
            throw new NoNodeAvailableException();
        }
        int index = this.randomNodeGenerator.incrementAndGet();
        for (int i = 0; i < nodes.size(); ++i) {
            DiscoveryNode node = (DiscoveryNode)nodes.get((index + i) % nodes.size());
            try {
                return callback.doWithNode(node);
            }
            catch (ConnectTransportException e) {
                continue;
            }
        }
        throw new NoNodeAvailableException();
    }

    public void close() {
        this.closed = true;
        this.nodesSamplerFuture.cancel(true);
        for (DiscoveryNode listedNode : this.listedNodes) {
            this.transportService.disconnectFromNode(listedNode);
        }
    }

    public static interface NodeCallback<T> {
        public T doWithNode(DiscoveryNode var1) throws ElasticSearchException;
    }

    private class ScheduledSniffNodesSampler
    implements Runnable {
        private ScheduledSniffNodesSampler() {
        }

        @Override
        public synchronized void run() {
            if (TransportClientNodesService.this.closed) {
                return;
            }
            ImmutableList listedNodes = TransportClientNodesService.this.listedNodes;
            final CountDownLatch latch = new CountDownLatch(listedNodes.size());
            final CopyOnWriteArrayList nodesInfoResponses = new CopyOnWriteArrayList();
            for (final DiscoveryNode listedNode : listedNodes) {
                TransportClientNodesService.this.threadPool.cached().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TransportClientNodesService.this.transportService.connectToNode(listedNode);
                            TransportClientNodesService.this.transportService.sendRequest(listedNode, "/cluster/nodes/info", Requests.nodesInfoRequest("_all"), new BaseTransportResponseHandler<NodesInfoResponse>(){

                                @Override
                                public NodesInfoResponse newInstance() {
                                    return new NodesInfoResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(NodesInfoResponse response) {
                                    nodesInfoResponses.add(response);
                                    latch.countDown();
                                }

                                @Override
                                public void handleException(TransportException exp) {
                                    TransportClientNodesService.this.logger.debug("Failed to get node info from " + listedNode + ", removed from nodes list", exp, new Object[0]);
                                    latch.countDown();
                                }
                            });
                        }
                        catch (Exception e) {
                            TransportClientNodesService.this.logger.debug("Failed to get node info from " + listedNode + ", removed from nodes list", e, new Object[0]);
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            for (NodesInfoResponse nodesInfoResponse : nodesInfoResponses) {
                for (NodeInfo nodeInfo : nodesInfoResponse) {
                    if (!TransportClientNodesService.this.clusterName.equals(nodesInfoResponse.clusterName())) {
                        TransportClientNodesService.this.logger.warn("Node {} not part of the cluster {}, ignoring...", nodeInfo.node(), TransportClientNodesService.this.clusterName);
                        continue;
                    }
                    if (!nodeInfo.node().dataNode()) continue;
                    newNodes.add(nodeInfo.node());
                }
            }
            Iterator it = newNodes.iterator();
            while (it.hasNext()) {
                DiscoveryNode node = (DiscoveryNode)it.next();
                try {
                    TransportClientNodesService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    it.remove();
                    TransportClientNodesService.this.logger.debug("Failed to connect to discovered node [" + node + "]", e, new Object[0]);
                }
            }
            TransportClientNodesService.this.nodes = (ImmutableList)((ImmutableList.Builder)new ImmutableList.Builder().addAll(newNodes)).build();
            if (!TransportClientNodesService.this.closed) {
                TransportClientNodesService.this.nodesSamplerFuture = TransportClientNodesService.this.threadPool.schedule(TransportClientNodesService.this.nodesSamplerInterval, "cached", this);
            }
        }
    }

    private class ScheduledConnectNodeSampler
    implements Runnable {
        private ScheduledConnectNodeSampler() {
        }

        @Override
        public synchronized void run() {
            if (TransportClientNodesService.this.closed) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            for (DiscoveryNode node : TransportClientNodesService.this.listedNodes) {
                if (!TransportClientNodesService.this.transportService.nodeConnected(node)) {
                    try {
                        TransportClientNodesService.this.transportService.connectToNode(node);
                    }
                    catch (Exception e) {
                        TransportClientNodesService.this.logger.debug("Failed to connect to node " + node + ", removed from nodes list", e, new Object[0]);
                        continue;
                    }
                }
                try {
                    NodesInfoResponse nodeInfo = TransportClientNodesService.this.transportService.submitRequest(node, "/cluster/nodes/info", Requests.nodesInfoRequest("_local"), new FutureTransportResponseHandler<NodesInfoResponse>(){

                        @Override
                        public NodesInfoResponse newInstance() {
                            return new NodesInfoResponse();
                        }
                    }).txGet();
                    if (!TransportClientNodesService.this.clusterName.equals(nodeInfo.clusterName())) {
                        TransportClientNodesService.this.logger.warn("Node {} not part of the cluster {}, ignoring...", node, TransportClientNodesService.this.clusterName);
                        continue;
                    }
                    newNodes.add(node);
                }
                catch (Exception e) {
                    TransportClientNodesService.this.logger.warn("failed to get node info for {}", e, node);
                }
            }
            TransportClientNodesService.this.nodes = (ImmutableList)((ImmutableList.Builder)new ImmutableList.Builder().addAll(newNodes)).build();
            if (!TransportClientNodesService.this.closed) {
                TransportClientNodesService.this.nodesSamplerFuture = TransportClientNodesService.this.threadPool.schedule(TransportClientNodesService.this.nodesSamplerInterval, "cached", this);
            }
        }
    }
}

