/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class FloatFieldMapper
extends NumberFieldMapper<Float> {
    public static final String CONTENT_TYPE = "float";
    private Float nullValue;
    private String nullValueAsString;

    protected FloatFieldMapper(FieldMapper.Names names, int precisionStep, String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Float nullValue) {
        super(names, precisionStep, fuzzyFactor, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_float/" + precisionStep, new NumericFloatAnalyzer(precisionStep)), new NamedAnalyzer("_float/max", new NumericFloatAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Float.valueOf(Numbers.bytesToFloat(value));
    }

    @Override
    public Float valueFromString(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.floatToPrefixCoded((float)Float.parseFloat(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value);
        float iSim = Float.parseFloat(minSim);
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value);
        float iSim = (float)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newFloatRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        float value;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue.floatValue();
            } else {
                value = ((Number)externalValue).floatValue();
            }
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), Float.toString(value), this.boost);
            }
        } else if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return null;
            }
            value = this.nullValue.floatValue();
            if (this.nullValueAsString != null && context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), this.nullValueAsString, this.boost);
            }
        } else {
            value = context.parser().floatValue();
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), context.parser().text(), this.boost);
            }
        }
        return new CustomFloatNumericField((NumberFieldMapper)this, value);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((FloatFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((FloatFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomFloatNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final float number;
        private final NumberFieldMapper mapper;

        public CustomFloatNumericField(NumberFieldMapper mapper, float number) {
            super(mapper, mapper.stored() ? Numbers.floatToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setFloatValue(this.number);
            }
            return null;
        }
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.floatField(name);
            XContentTypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, FloatFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public FloatFieldMapper build(XContentMapper.BuilderContext context) {
            FloatFieldMapper fieldMapper = new FloatFieldMapper(this.buildNames(context), this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Float NULL_VALUE = null;
    }
}

