/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.DateFieldMapper;
import org.elasticsearch.index.mapper.xcontent.DynamicTemplate;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ObjectMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;

public class RootObjectMapper
extends ObjectMapper {
    private final FormatDateTimeFormatter[] dateTimeFormatters;
    private volatile DynamicTemplate[] dynamicTemplates;

    RootObjectMapper(String name, boolean enabled, ObjectMapper.Dynamic dynamic, ContentPath.Type pathType, Map<String, XContentMapper> mappers, FormatDateTimeFormatter[] dateTimeFormatters, DynamicTemplate[] dynamicTemplates) {
        super(name, enabled, dynamic, pathType, mappers);
        this.dynamicTemplates = dynamicTemplates;
        this.dateTimeFormatters = dateTimeFormatters;
    }

    public FormatDateTimeFormatter[] dateTimeFormatters() {
        return this.dateTimeFormatters;
    }

    public XContentMapper.Builder findTemplateBuilder(ParseContext context, String name, String dynamicType) {
        DynamicTemplate dynamicTemplate = this.findTemplate(context.path(), name, dynamicType);
        if (dynamicTemplate == null) {
            return null;
        }
        XContentMapper.TypeParser.ParserContext parserContext = context.docMapperParser().parserContext();
        return parserContext.typeParser(dynamicTemplate.mappingType(dynamicType)).parse(name, dynamicTemplate.mappingForName(name, dynamicType), parserContext);
    }

    public DynamicTemplate findTemplate(ContentPath path, String name, String dynamicType) {
        for (DynamicTemplate dynamicTemplate : this.dynamicTemplates) {
            if (!dynamicTemplate.match(path, name, dynamicType)) continue;
            return dynamicTemplate;
        }
        return null;
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith, MergeContext mergeContext) {
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            ArrayList<DynamicTemplate> mergedTemplates = Lists.newArrayList(Arrays.asList(this.dynamicTemplates));
            for (DynamicTemplate template : mergeWithObject.dynamicTemplates) {
                boolean replaced = false;
                for (int i = 0; i < mergedTemplates.size(); ++i) {
                    if (!((DynamicTemplate)mergedTemplates.get(i)).name().equals(template.name())) continue;
                    mergedTemplates.set(i, template);
                    replaced = true;
                }
                if (replaced) continue;
                mergedTemplates.add(template);
            }
            this.dynamicTemplates = mergedTemplates.toArray(new DynamicTemplate[mergedTemplates.size()]);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dateTimeFormatters != Defaults.DATE_TIME_FORMATTERS && this.dateTimeFormatters.length > 0) {
            builder.startArray("date_formats");
            for (FormatDateTimeFormatter dateTimeFormatter : this.dateTimeFormatters) {
                builder.value(dateTimeFormatter.format());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates != null && this.dynamicTemplates.length > 0) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates) {
                builder.startObject();
                builder.field(dynamicTemplate.name());
                builder.map(dynamicTemplate.conf());
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        protected ObjectMapper.Builder createBuilder(String name) {
            return new Builder(name);
        }

        @Override
        protected void processField(ObjectMapper.Builder builder, String fieldName, Object fieldNode) {
            if (fieldName.equals("date_formats")) {
                ArrayList<FormatDateTimeFormatter> dateTimeFormatters = Lists.newArrayList();
                if (fieldNode instanceof List) {
                    for (Object node1 : (List)fieldNode) {
                        dateTimeFormatters.add(XContentTypeParsers.parseDateTimeFormatter(fieldName, node1));
                    }
                } else if ("none".equals(fieldNode.toString())) {
                    dateTimeFormatters = null;
                } else {
                    dateTimeFormatters.add(XContentTypeParsers.parseDateTimeFormatter(fieldName, fieldNode));
                }
                if (dateTimeFormatters == null) {
                    ((Builder)builder).noDateTimeFormatter();
                } else {
                    ((Builder)builder).dateTimeFormatter(dateTimeFormatters);
                }
            } else if (fieldName.equals("dynamic_templates")) {
                List tmplNodes = (List)fieldNode;
                for (Object tmplNode : tmplNodes) {
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    ((Builder)builder).add(DynamicTemplate.parse((String)entry.getKey(), (Map)entry.getValue()));
                }
            }
        }
    }

    public static class Builder
    extends ObjectMapper.Builder<Builder, RootObjectMapper> {
        protected final List<DynamicTemplate> dynamicTemplates = Lists.newArrayList();
        protected List<FormatDateTimeFormatter> dateTimeFormatters = Lists.newArrayList();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder noDateTimeFormatter() {
            this.dateTimeFormatters = null;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(Iterable<FormatDateTimeFormatter> dateTimeFormatters) {
            for (FormatDateTimeFormatter dateTimeFormatter : dateTimeFormatters) {
                this.dateTimeFormatters.add(dateTimeFormatter);
            }
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter[] dateTimeFormatters) {
            this.dateTimeFormatters.addAll(Lists.newArrayList(dateTimeFormatters));
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatters.add(dateTimeFormatter);
            return (Builder)this.builder;
        }

        public Builder add(DynamicTemplate dynamicTemplate) {
            this.dynamicTemplates.add(dynamicTemplate);
            return this;
        }

        public Builder add(DynamicTemplate ... dynamicTemplate) {
            for (DynamicTemplate template : dynamicTemplate) {
                this.dynamicTemplates.add(template);
            }
            return this;
        }

        @Override
        protected ObjectMapper createMapper(String name, boolean enabled, ObjectMapper.Dynamic dynamic, ContentPath.Type pathType, Map<String, XContentMapper> mappers) {
            FormatDateTimeFormatter[] dates = null;
            dates = this.dateTimeFormatters == null ? new FormatDateTimeFormatter[]{} : (this.dateTimeFormatters.isEmpty() ? Defaults.DATE_TIME_FORMATTERS : this.dateTimeFormatters.toArray(new FormatDateTimeFormatter[this.dateTimeFormatters.size()]));
            if (dynamic == null) {
                dynamic = ObjectMapper.Dynamic.TRUE;
            }
            return new RootObjectMapper(name, enabled, dynamic, pathType, mappers, dates, this.dynamicTemplates.toArray(new DynamicTemplate[this.dynamicTemplates.size()]));
        }
    }

    public static class Defaults {
        public static final FormatDateTimeFormatter[] DATE_TIME_FORMATTERS = new FormatDateTimeFormatter[]{DateFieldMapper.Defaults.DATE_TIME_FORMATTER, Joda.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd")};
    }
}

