/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseFilterBuilder;
import org.elasticsearch.index.query.xcontent.XContentFilterBuilder;

public class OrFilterBuilder
extends BaseFilterBuilder {
    private ArrayList<XContentFilterBuilder> filters = Lists.newArrayList();
    private Boolean cache;
    private String filterName;

    public OrFilterBuilder(XContentFilterBuilder ... filters) {
        for (XContentFilterBuilder filter : filters) {
            this.filters.add(filter);
        }
    }

    public OrFilterBuilder add(XContentFilterBuilder filterBuilder) {
        this.filters.add(filterBuilder);
        return this;
    }

    public OrFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public OrFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("or");
        builder.startArray("filters");
        for (XContentFilterBuilder filter : this.filters) {
            filter.toXContent(builder, params);
        }
        builder.endArray();
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        builder.endObject();
    }
}

