/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseFilterBuilder;

public class TermFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final Object value;
    private Boolean cache;
    private String filterName;

    public TermFilterBuilder(String name, String value) {
        this(name, (Object)value);
    }

    public TermFilterBuilder(String name, int value) {
        this(name, (Object)value);
    }

    public TermFilterBuilder(String name, long value) {
        this(name, (Object)value);
    }

    public TermFilterBuilder(String name, float value) {
        this(name, Float.valueOf(value));
    }

    public TermFilterBuilder(String name, double value) {
        this(name, (Object)value);
    }

    public TermFilterBuilder(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public TermFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public TermFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("term");
        builder.field(this.name, this.value);
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        builder.endObject();
    }
}

