/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NetworkInfo
implements Streamable,
Serializable,
ToXContent {
    public static final Interface NA_INTERFACE = new Interface();
    long refreshInterval;
    Interface primary = NA_INTERFACE;

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Interface primaryInterface() {
        return this.primary;
    }

    public Interface getPrimaryInterface() {
        return this.primaryInterface();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("network");
        builder.field("refresh_interval", this.refreshInterval);
        if (this.primary != NA_INTERFACE) {
            builder.startObject("primary_interface");
            builder.field("address", this.primary.address());
            builder.field("name", this.primary.name());
            builder.field("mac_address", this.primary.macAddress());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static NetworkInfo readNetworkInfo(StreamInput in) throws IOException {
        NetworkInfo info = new NetworkInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        this.primary = Interface.readNetworkInterface(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        this.primary.writeTo(out);
    }

    public static class Interface
    implements Streamable,
    Serializable {
        private String name = "";
        private String address = "";
        private String macAddress = "";

        private Interface() {
        }

        public Interface(String name, String address, String macAddress) {
            this.name = name;
            this.address = address;
            this.macAddress = macAddress;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name();
        }

        public String address() {
            return this.address;
        }

        public String getAddress() {
            return this.address();
        }

        public String macAddress() {
            return this.macAddress;
        }

        public String getMacAddress() {
            return this.macAddress();
        }

        public static Interface readNetworkInterface(StreamInput in) throws IOException {
            Interface inf = new Interface();
            inf.readFrom(in);
            return inf;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.address = in.readUTF();
            this.macAddress = in.readUTF();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeUTF(this.address);
            out.writeUTF(this.macAddress);
        }
    }
}

