/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArabicAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    @Deprecated
    public static final String STOPWORDS_COMMENT = "#";
    private final Set<?> stemExclusionSet;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ArabicAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ArabicAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public ArabicAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclusionSet));
    }

    @Deprecated
    public ArabicAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopwords));
    }

    @Deprecated
    public ArabicAnalyzer(Version matchVersion, Hashtable<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    @Deprecated
    public ArabicAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords, (String)STOPWORDS_COMMENT));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Object source = this.matchVersion.onOrAfter(Version.LUCENE_31) ? new StandardTokenizer(this.matchVersion, reader) : new ArabicLetterTokenizer(this.matchVersion, reader);
        Object result = new LowerCaseFilter(this.matchVersion, (TokenStream)source);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        result = new ArabicNormalizationFilter((TokenStream)result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new ArabicStemFilter((TokenStream)result));
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = ArabicAnalyzer.loadStopwordSet((boolean)false, (Class)ArabicAnalyzer.class, (String)ArabicAnalyzer.DEFAULT_STOPWORD_FILE, (String)ArabicAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

