/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import play.Logger;
import play.Play;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.Query;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.JPATransformer;
import play.modules.elasticsearch.transformer.Transformer;

public abstract class ElasticSearch {
    public static Client client() {
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        return plugin.client();
    }

    private static <T extends Model> SearchRequestBuilder builder(XContentQueryBuilder queryBuilder, Class<T> clazz) {
        String index = ElasticSearchAdapter.getIndexName(clazz);
        SearchRequestBuilder builder = ElasticSearch.client().prepareSearch(new String[]{index}).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery(queryBuilder);
        return builder;
    }

    public static <T extends Model> Query query(XContentQueryBuilder queryBuilder, Class<T> clazz) {
        return new Query<T>(clazz, ElasticSearch.builder(queryBuilder, clazz));
    }

    public static <T extends Model> SearchResults search(XContentQueryBuilder queryBuilder, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(queryBuilder, clazz, false, facets);
    }

    public static <T extends Model> SearchResults searchAndHydrate(XContentQueryBuilder queryBuilder, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(queryBuilder, clazz, true, facets);
    }

    private static <T extends Model> SearchResults search(XContentQueryBuilder queryBuilder, Class<T> clazz, boolean hydrate, AbstractFacetBuilder ... facets) {
        SearchRequestBuilder builder = ElasticSearch.builder(queryBuilder, clazz);
        for (AbstractFacetBuilder facet : facets) {
            builder.addFacet(facet);
        }
        if (hydrate) {
            builder.addField("_id");
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)"ES Query: %s", (Object[])new Object[]{builder.toString()});
        }
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        SearchResults<T> searchResults = null;
        searchResults = hydrate ? JPATransformer.toSearchResults(searchResponse, clazz) : Transformer.toSearchResults(searchResponse, clazz);
        return searchResults;
    }
}

