/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import akka.actor.ActorRef;
import akka.actor.Actors;
import akka.amqp.AMQP;
import akka.amqp.Direct;
import akka.amqp.Direct$;
import akka.amqp.ExchangeType;
import com.rabbitmq.client.Address;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchDeliveryMode;
import play.modules.elasticsearch.ElasticSearchIndexEvent;
import play.modules.elasticsearch.ElasticSearchIndexer;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.rabbitmq.RabbitMQConsumerActor;
import play.modules.elasticsearch.util.ExceptionUtil;
import play.mvc.Router;

public class ElasticSearchPlugin
extends PlayPlugin {
    private static boolean started = false;
    private static boolean consumerStarted = false;
    private static Map<Class<?>, Boolean> modelIndex = null;
    private static Client client = null;

    public static Client client() {
        return client;
    }

    private boolean isLocalMode() {
        try {
            String client = Play.configuration.getProperty("elasticsearch.client");
            Boolean local = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.local", "true"));
            if (client == null) {
                return true;
            }
            if (client.equalsIgnoreCase("false") || client.equalsIgnoreCase("true")) {
                return true;
            }
            return local;
        }
        catch (Exception e) {
            Logger.error((String)"Error! Starting in Local Model: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(e)});
            return true;
        }
    }

    public static String getHosts() {
        String s = Play.configuration.getProperty("elasticsearch.client");
        if (s == null) {
            return "";
        }
        return s;
    }

    public static ElasticSearchDeliveryMode getDeliveryModel() {
        String s = Play.configuration.getProperty("elasticsearch.delivery");
        if (s == null) {
            return ElasticSearchDeliveryMode.LOCAL;
        }
        return ElasticSearchDeliveryMode.valueOf(s.toUpperCase());
    }

    public static String getRabbitMQQueue() {
        String s = Play.configuration.getProperty("elasticsearch.rabbitmq.queue");
        if (s == null) {
            return "elasticSearchQueue";
        }
        return s;
    }

    public void onApplicationStart() {
        modelIndex = new HashMap();
        if (client != null || started) {
            Logger.debug((String)"Elastic Search Started Already!", (Object[])new Object[0]);
            return;
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("client.transport.sniff", true);
        settings.build();
        if (this.isLocalMode()) {
            Logger.info((String)"Starting Elastic Search for Play! in Local Mode", (Object[])new Object[0]);
            NodeBuilder nb = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).local(true).client(false).data(true);
            Node node = nb.node();
            client = node.client();
        } else {
            Logger.info((String)"Connecting Play! to Elastic Search in Client Mode", (Object[])new Object[0]);
            TransportClient c = new TransportClient((Settings.Builder)settings);
            if (Play.configuration.getProperty("elasticsearch.client") == null) {
                throw new RuntimeException("Configuration required - elasticsearch.client when local model is disabled!");
            }
            String[] hosts = ElasticSearchPlugin.getHosts().trim().split(",");
            boolean done = false;
            for (String host : hosts) {
                String[] parts = host.split(":");
                if (parts.length != 2) {
                    throw new RuntimeException("Invalid Host: " + host);
                }
                Logger.info((String)"Transport Client - Host: %s Port: %s", (Object[])new Object[]{parts[0], parts[1]});
                c.addTransportAddress((TransportAddress)new InetSocketTransportAddress(parts[0], Integer.valueOf(parts[1]).intValue()));
                done = true;
            }
            if (!done) {
                throw new RuntimeException("No Hosts Provided for Elastic Search!");
            }
            client = c;
        }
        Router.addRoute((String)"GET", (String)"/es-admin/", (String)"elasticsearch.ElasticSearchAdmin.index");
        if (client == null) {
            throw new RuntimeException("Elastic Search Client cannot be null - please check the configuration provided and the health of your Elastic Search instances.");
        }
    }

    private boolean isElasticSearchable(Object o) {
        for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Annotation a : clazz.getAnnotations()) {
                if (((Object)a).toString().indexOf("ElasticSearchable") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public void onEvent(String message, Object context) {
        Logger.info((String)"Event: %s - Object: %s", (Object[])new Object[]{message, context});
        if (!(message.endsWith(".objectPersisted") && message.endsWith(".objectUpdated") && message.endsWith(".objectDeleted"))) {
            return;
        }
        boolean isSearchable = this.isElasticSearchable(context);
        if (!isSearchable) {
            return;
        }
        if (!consumerStarted && ElasticSearchPlugin.getDeliveryModel().equals((Object)ElasticSearchDeliveryMode.RABBITMQ)) {
            Logger.info((String)"Triggering RabbitMQConsumer for Elastic Search...", (Object[])new Object[0]);
            Direct$ directExchange = Direct.getInstance();
            AMQP.ExchangeParameters params = new AMQP.ExchangeParameters(ElasticSearchPlugin.getRabbitMQQueue(), (ExchangeType)directExchange);
            Address address = new Address(Play.configuration.getProperty("elasticsearch.rabbitmq.host"), Integer.valueOf(Play.configuration.getProperty("elasticsearch.rabbitmq.port")).intValue());
            Address[] addresses = new Address[]{address};
            AMQP.ConnectionParameters connectionParameters = new AMQP.ConnectionParameters(addresses, Play.configuration.getProperty("elasticsearch.rabbitmq.username"), Play.configuration.getProperty("elasticsearch.rabbitmq.password"), Play.configuration.getProperty("elasticsearch.rabbitmq.virtualHost"));
            ActorRef connection = AMQP.newConnection((AMQP.ConnectionParameters)connectionParameters);
            ActorRef ref = Actors.actorOf(RabbitMQConsumerActor.class);
            AMQP.ConsumerParameters consumerParams = new AMQP.ConsumerParameters(ElasticSearchPlugin.getRabbitMQQueue(), ref, params);
            AMQP.newConsumer((ActorRef)ref, (AMQP.ConsumerParameters)consumerParams);
            consumerStarted = true;
        }
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        Class<?> clazz = context.getClass();
        if (!modelIndex.containsKey(clazz)) {
            Logger.info((String)"Start Index for Class: %s", (Object[])new Object[]{clazz});
            ElasticSearchAdapter.startIndex(plugin.client(), clazz);
            modelIndex.put(clazz, Boolean.TRUE);
        }
        ElasticSearchIndexEvent event = null;
        if (message.endsWith(".objectPersisted") || message.endsWith(".objectUpdated")) {
            event = new ElasticSearchIndexEvent((Model)context, ElasticSearchIndexEvent.Type.INDEX);
        } else if (message.endsWith(".objectDeleted")) {
            event = new ElasticSearchIndexEvent((Model)context, ElasticSearchIndexEvent.Type.DELETE);
        }
        Logger.info((String)"Elastic Search Index Event: %s", (Object[])new Object[]{event});
        if (event != null) {
            if (ElasticSearchPlugin.getDeliveryModel().equals((Object)ElasticSearchDeliveryMode.RABBITMQ)) {
                Direct$ directExchange = Direct.getInstance();
                AMQP.ExchangeParameters params = new AMQP.ExchangeParameters(ElasticSearchPlugin.getRabbitMQQueue(), (ExchangeType)directExchange);
                AMQP.ProducerParameters producerParams = new AMQP.ProducerParameters(params);
                Address address = new Address(Play.configuration.getProperty("elasticsearch.rabbitmq.host"), Integer.valueOf(Play.configuration.getProperty("elasticsearch.rabbitmq.port")).intValue());
                Address[] addresses = new Address[]{address};
                AMQP.ConnectionParameters connectionParameters = new AMQP.ConnectionParameters(addresses, Play.configuration.getProperty("elasticsearch.rabbitmq.username"), Play.configuration.getProperty("elasticsearch.rabbitmq.password"), Play.configuration.getProperty("elasticsearch.rabbitmq.virtualHost"));
                ActorRef connection = AMQP.newConnection((AMQP.ConnectionParameters)connectionParameters);
                ActorRef producer = AMQP.newProducer((ActorRef)connection, (AMQP.ProducerParameters)producerParams);
                producer.sendOneWay((Object)event);
            } else {
                ElasticSearchIndexer.stream.publish((Object)event);
            }
        }
    }
}

