/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtils {
    private IOUtils() {
    }

    public static <E extends Exception> void closeSafely(E priorException, Closeable ... objects) throws E, IOException {
        IOException firstIOE = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (IOException ioe) {
                if (firstIOE != null) continue;
                firstIOE = ioe;
            }
        }
        if (priorException != null) {
            throw priorException;
        }
        if (firstIOE != null) {
            throw firstIOE;
        }
    }

    public static void closeSafely(Closeable ... objects) throws IOException {
        IOException firstIOE = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (IOException ioe) {
                if (firstIOE != null) continue;
                firstIOE = ioe;
            }
        }
        if (firstIOE != null) {
            throw firstIOE;
        }
    }
}

