/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ExistsFieldQueryExtension;
import org.apache.lucene.queryParser.FieldQueryExtension;
import org.apache.lucene.queryParser.MissingFieldQueryExtension;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;

public class MapperQueryParser
extends QueryParser {
    public static final ImmutableMap<String, FieldQueryExtension> fieldQueryExtensions = ImmutableMap.builder().put("_exists_", new ExistsFieldQueryExtension()).put("_missing_", (ExistsFieldQueryExtension)((Object)new MissingFieldQueryExtension())).build();
    private final QueryParseContext parseContext;
    private FieldMapper currentMapper;
    private boolean analyzeWildcard;

    public MapperQueryParser(QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, null, null);
        this.parseContext = parseContext;
    }

    public MapperQueryParser(QueryParserSettings settings, QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, settings.defaultField(), settings.analyzer());
        this.parseContext = parseContext;
        this.reset(settings);
    }

    public void reset(QueryParserSettings settings) {
        this.field = settings.defaultField();
        this.analyzer = settings.analyzer();
        this.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        this.setEnablePositionIncrements(settings.enablePositionIncrements());
        this.setAutoGeneratePhraseQueries(settings.autoGeneratePhraseQueries());
        this.setAllowLeadingWildcard(settings.allowLeadingWildcard());
        this.setLowercaseExpandedTerms(settings.lowercaseExpandedTerms());
        this.setPhraseSlop(settings.phraseSlop());
        this.setDefaultOperator(settings.defaultOperator());
        this.setFuzzyMinSim(settings.fuzzyMinSim());
        this.setFuzzyPrefixLength(settings.fuzzyPrefixLength());
        this.analyzeWildcard = settings.analyzeWildcard();
    }

    protected Query newTermQuery(Term term) {
        Query termQuery;
        if (this.currentMapper != null && (termQuery = this.currentMapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return super.newTermQuery(term);
    }

    protected Query newMatchAllDocsQuery() {
        return Queries.MATCH_ALL_QUERY;
    }

    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        FieldQueryExtension fieldQueryExtension = fieldQueryExtensions.get(field);
        if (fieldQueryExtension != null) {
            return fieldQueryExtension.query(this.parseContext, queryText);
        }
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                Query query = null;
                if (this.currentMapper.useFieldQueryWithQueryString()) {
                    query = this.currentMapper.fieldQuery(queryText, this.parseContext);
                }
                if (query == null) {
                    query = super.getFieldQuery(this.currentMapper.names().indexName(), queryText, quoted);
                }
                return QueryParsers.wrapSmartNameQuery(query, fieldMappers, this.parseContext);
            }
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                Query rangeQuery = this.currentMapper.rangeQuery(part1, part2, inclusive, inclusive);
                return QueryParsers.wrapSmartNameQuery(rangeQuery, fieldMappers, this.parseContext);
            }
        }
        return this.newRangeQuery(field, part1, part2, inclusive);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                Query fuzzyQuery = this.currentMapper.fuzzyQuery(termStr, minSimilarity, this.fuzzyPrefixLength, Integer.MAX_VALUE);
                return QueryParsers.wrapSmartNameQuery(fuzzyQuery, fieldMappers, this.parseContext);
            }
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        String indexedNameField = field;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                indexedNameField = this.currentMapper.names().indexName();
            }
            return QueryParsers.wrapSmartNameQuery(this.getPossiblyAnalyzedPrefixQuery(indexedNameField, termStr), fieldMappers, this.parseContext);
        }
        return this.getPossiblyAnalyzedPrefixQuery(indexedNameField, termStr);
    }

    private Query getPossiblyAnalyzedPrefixQuery(String field, String termStr) throws ParseException {
        TokenStream source;
        if (!this.analyzeWildcard) {
            return super.getPrefixQuery(field, termStr);
        }
        try {
            source = this.getAnalyzer().reusableTokenStream(field, (Reader)new StringReader(termStr));
        }
        catch (IOException e) {
            return super.getPrefixQuery(field, termStr);
        }
        ArrayList<String> tlist = new ArrayList<String>();
        CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
        while (true) {
            try {
                if (!source.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            tlist.add(termAtt.toString());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field, (String)tlist.get(0));
        }
        return super.getPrefixQuery(field, termStr);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        MapperService.SmartNameFieldMappers fieldMappers;
        if ("_all".equals(field) && termStr.equals("*")) {
            return this.newMatchAllDocsQuery();
        }
        String indexedNameField = field;
        this.currentMapper = null;
        if (this.parseContext.mapperService() != null && (fieldMappers = this.parseContext.mapperService().smartName(field)) != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                indexedNameField = this.currentMapper.names().indexName();
            }
            return QueryParsers.wrapSmartNameQuery(this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr), fieldMappers, this.parseContext);
        }
        return this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr);
    }

    private Query getPossiblyAnalyzedWildcardQuery(String field, String termStr) throws ParseException {
        if (!this.analyzeWildcard) {
            return super.getWildcardQuery(field, termStr);
        }
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuilder aggStr = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < termStr.length(); ++i) {
            char c = termStr.charAt(i);
            if (c == '?' || c == '*') {
                if (isWithinToken) {
                    try {
                        TokenStream source = this.getAnalyzer().reusableTokenStream(field, (Reader)new FastStringReader(tmp.toString()));
                        CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
                        if (source.incrementToken()) {
                            String term = termAtt.toString();
                            if (term.length() == 0) {
                                aggStr.append((CharSequence)tmp);
                            } else {
                                aggStr.append(term);
                            }
                        } else {
                            aggStr.append((CharSequence)tmp);
                        }
                        source.close();
                    }
                    catch (IOException e) {
                        aggStr.append((CharSequence)tmp);
                    }
                    tmp.setLength(0);
                }
                isWithinToken = false;
                aggStr.append(c);
                continue;
            }
            tmp.append(c);
            isWithinToken = true;
        }
        if (isWithinToken) {
            try {
                TokenStream source = this.getAnalyzer().reusableTokenStream(field, (Reader)new FastStringReader(tmp.toString()));
                CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
                if (source.incrementToken()) {
                    String term = termAtt.toString();
                    if (term.length() == 0) {
                        aggStr.append((CharSequence)tmp);
                    } else {
                        aggStr.append(term);
                    }
                } else {
                    aggStr.append((CharSequence)tmp);
                }
                source.close();
            }
            catch (IOException e) {
                aggStr.append((CharSequence)tmp);
            }
        }
        return super.getWildcardQuery(field, aggStr.toString());
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        Query q = super.getBooleanQuery(clauses, disableCoord);
        if (q == null) {
            return null;
        }
        return Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(q));
    }

    protected FieldMapper fieldMapper(String smartName) {
        if (this.parseContext.mapperService() == null) {
            return null;
        }
        FieldMappers fieldMappers = this.parseContext.mapperService().smartNameFieldMappers(smartName);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }
}

