/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.io.Closeables;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class Directories {
    public static ByteSizeValue estimateSize(Directory directory) throws IOException {
        String[] files;
        long estimatedSize = 0L;
        for (String file : files = directory.listAll()) {
            try {
                estimatedSize += directory.fileLength(file);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return new ByteSizeValue(estimatedSize);
    }

    public static Collection<IndexCommit> listCommits(Directory directory) throws IOException {
        return IndexReader.listCommits((Directory)directory);
    }

    public static void copyFromDirectory(Directory dir, String fileName, File copyTo, boolean nativeCopy) throws IOException {
        if (nativeCopy && dir instanceof FSDirectory) {
            if (!copyTo.exists()) {
                copyTo.createNewFile();
            }
            FileSystemUtils.copyFile(new File(((FSDirectory)dir).getDirectory(), fileName), copyTo);
        } else {
            Directories.copyFromDirectory(dir.openInput(fileName), new FileOutputStream(copyTo));
        }
        FileSystemUtils.syncFile(copyTo);
    }

    public static void copyFromDirectory(Directory dir, String fileName, OutputStream os) throws IOException {
        Directories.copyFromDirectory(dir.openInput(fileName), os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromDirectory(IndexInput ii, OutputStream os) throws IOException {
        int BUFFER_SIZE = ii.length() < 16384L ? (int)ii.length() : 16384;
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            int toRead;
            long len = ii.length();
            for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                toRead = readCount + (long)BUFFER_SIZE > len ? (int)(len - readCount) : BUFFER_SIZE;
                ii.readBytes(buffer, 0, toRead, false);
                os.write(buffer, 0, toRead);
            }
        }
        finally {
            Closeables.closeQuietly(os);
            Closeables.closeQuietly((Closeable)ii);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyToDirectory(File copyFrom, Directory dir, String fileName, boolean nativeCopy) throws IOException {
        if (nativeCopy && dir instanceof FSDirectory) {
            File destinationFile = new File(((FSDirectory)dir).getDirectory(), fileName);
            if (!destinationFile.exists()) {
                destinationFile.createNewFile();
            }
            FileSystemUtils.copyFile(copyFrom, destinationFile);
        } else {
            FileInputStream is = null;
            IndexOutput output = null;
            try {
                is = new FileInputStream(copyFrom);
                output = dir.createOutput(fileName);
                Directories.copyToDirectory(is, output);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                Closeables.closeQuietly(output);
                throw throwable;
            }
            Closeables.closeQuietly(is);
            Closeables.closeQuietly((Closeable)output);
        }
        Directories.sync(dir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToDirectory(InputStream is, Directory dir, String fileName) throws IOException {
        IndexOutput output = null;
        try {
            output = dir.createOutput(fileName);
            Directories.copyToDirectory(is, output);
        }
        finally {
            Closeables.closeQuietly(is);
            Closeables.closeQuietly((Closeable)output);
        }
        Directories.sync(dir, fileName);
    }

    public static void sync(Directory dir, String fileName) throws IOException {
        if (dir instanceof ForceSyncDirectory) {
            ((ForceSyncDirectory)dir).forceSync(fileName);
        } else {
            dir.sync(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToDirectory(InputStream is, IndexOutput io) throws IOException {
        byte[] buffer = new byte[16384];
        try {
            int len;
            while ((len = is.read(buffer)) != -1) {
                io.writeBytes(buffer, len);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)io);
            Closeables.closeQuietly(is);
        }
    }

    private Directories() {
    }
}

