/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.Map;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.Safe;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.compiler.ExpressionCompiler;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.FunctionVariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class Function
extends ASTNode
implements Safe {
    protected String name;
    protected ExecutableStatement compiledBlock;
    protected String[] parameters;
    protected int parmNum;
    protected boolean cMode = false;

    public Function(String name, char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        this.name = name;
        if (this.name == null || name.length() == 0) {
            this.name = null;
        }
        this.expr = expr;
        this.parameters = ParseTools.parseParameterDefList(expr, start, offset);
        this.parmNum = this.parameters.length;
        pCtx.declareFunction(this);
        ParserContext ctx = new ParserContext(pCtx.getParserConfiguration());
        for (String s : this.parameters) {
            ctx.addVariable(s, Object.class);
            ctx.addIndexedInput(s);
        }
        ctx.setIndexAllocation(false);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, blockStart, blockOffset);
        compiler.setVerifyOnly(true);
        compiler.compile(ctx);
        ctx.setIndexAllocation(true);
        if (pCtx.getVariables() != null) {
            for (Map.Entry<String, Class> e : pCtx.getVariables().entrySet()) {
                ctx.getVariables().remove(e.getKey());
                ctx.addInput(e.getKey(), e.getValue());
            }
            ctx.processTables();
        }
        ctx.addIndexedInputs(ctx.getVariables().keySet());
        ctx.getVariables().clear();
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, ctx);
        AbstractParser.setCurrentThreadParserContext(pCtx);
        this.parameters = new String[ctx.getIndexedInputs().size()];
        int i = 0;
        for (String s : ctx.getIndexedInputs()) {
            this.parameters[i++] = s;
        }
        this.cMode = (fields & 0x10) != 0;
        this.egressType = this.compiledBlock.getKnownEgressType();
        pCtx.addVariable(name, Function.class);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (!factory.isIndexedFactory() && factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (!factory.isIndexedFactory() && factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
        if (parms != null && parms.length != 0) {
            FunctionVariableResolverFactory fvrf;
            if (factory instanceof FunctionVariableResolverFactory && ((FunctionVariableResolverFactory)factory).getIndexedVariableResolvers().length == parms.length && (fvrf = (FunctionVariableResolverFactory)factory).getFunction().equals(this)) {
                VariableResolver[] swapVR = fvrf.getIndexedVariableResolvers();
                fvrf.updateParameters(parms);
                try {
                    Object object = this.compiledBlock.getValue(ctx, thisValue, fvrf);
                    return object;
                }
                finally {
                    fvrf.setIndexedVariableResolvers(swapVR);
                }
            }
            return this.compiledBlock.getValue(thisValue, new FunctionVariableResolverFactory(this, factory, this.parameters, parms));
        }
        if (this.cMode) {
            return this.compiledBlock.getValue(thisValue, new DefaultLocalVariableResolverFactory(factory, this.parameters).setNoTilt(true));
        }
        return this.compiledBlock.getValue(thisValue, new DefaultLocalVariableResolverFactory(factory).setNoTilt(true));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public void checkArgumentCount(int passing) {
        if (passing != this.parmNum) {
            throw new CompileException("bad number of arguments in function call: " + passing + " (expected: " + (this.parmNum == 0 ? "none" : Integer.valueOf(this.parmNum)) + ")", this.expr, this.start);
        }
    }

    public ExecutableStatement getCompiledBlock() {
        return this.compiledBlock;
    }

    public String toString() {
        return "FunctionDef:" + (this.name == null ? "Anonymous" : this.name);
    }
}

