/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.resident;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.support.AbstractConcurrentMapFieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;

public class ResidentFieldDataCache
extends AbstractConcurrentMapFieldDataCache
implements MapEvictionListener<String, FieldData> {
    private final IndexSettingsService indexSettingsService;
    private volatile int maxSize;
    private volatile TimeValue expire;
    private final AtomicLong evictions = new AtomicLong();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public ResidentFieldDataCache(Index index, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(index, indexSettings);
        this.indexSettingsService = indexSettingsService;
        this.maxSize = indexSettings.getAsInt("index.cache.field.max_size", this.componentSettings.getAsInt("max_size", -1));
        this.expire = indexSettings.getAsTime("index.cache.field.expire", this.componentSettings.getAsTime("expire", null));
        this.logger.debug("using [resident] field cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() throws ElasticSearchException {
        this.indexSettingsService.removeListener(this.applySettings);
        super.close();
    }

    @Override
    protected ConcurrentMap<String, FieldData> buildFieldDataMap() {
        MapMaker mapMaker = new MapMaker();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        if (this.expire != null) {
            mapMaker.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        mapMaker.evictionListener(this);
        return mapMaker.makeMap();
    }

    @Override
    public String type() {
        return "resident";
    }

    @Override
    public long evictions() {
        return this.evictions.get();
    }

    @Override
    public void onEviction(@Nullable String s, @Nullable FieldData fieldData) {
        this.evictions.incrementAndGet();
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int maxSize = settings.getAsInt("index.cache.field.max_size", ResidentFieldDataCache.this.maxSize);
            TimeValue expire = settings.getAsTime("index.cache.field.expire", ResidentFieldDataCache.this.expire);
            boolean changed = false;
            if (maxSize != ResidentFieldDataCache.this.maxSize) {
                ResidentFieldDataCache.this.logger.info("updating index.cache.field.max_size from [{}] to [{}]", ResidentFieldDataCache.this.maxSize, maxSize);
                changed = true;
                ResidentFieldDataCache.this.maxSize = maxSize;
            }
            if (!Objects.equal(expire, ResidentFieldDataCache.this.expire)) {
                ResidentFieldDataCache.this.logger.info("updating index.cache.field.expire from [{}] to [{}]", ResidentFieldDataCache.this.expire, expire);
                changed = true;
                ResidentFieldDataCache.this.expire = expire;
            }
            if (changed) {
                ResidentFieldDataCache.this.clear();
            }
        }
    }
}

